/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.AbstractHashFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Hash;

public class Sha256
extends AbstractHashFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "SHA256", Sha256::new);
    private static final Hash.HashFunction SHA256 = Hash.HashFunction.create("SHA256");

    @FunctionInfo(returnType={"keyword"}, description="Computes the SHA256 hash of the input.", examples={@Example(file="hash", tag="sha256")})
    public Sha256(Source source, @Param(name="input", type={"keyword", "text"}, description="Input to hash.") Expression input) {
        super(source, input);
    }

    private Sha256(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    protected Hash.HashFunction getHashFunction() {
        return SHA256;
    }

    public String getWriteableName() {
        return Sha256.ENTRY.name;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new Sha256(this.source(), newChildren.get(0));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Sha256::new, this.field);
    }
}

