/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.index.mapper.blockloader.BlockLoaderFunctionConfig;
import org.elasticsearch.index.mapper.blockloader.Warnings;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.BlockLoaderWarnings;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.blockloader.BlockLoaderExpression;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.LengthEvaluator;
import org.elasticsearch.xpack.esql.stats.SearchStats;

public class Length
extends UnaryScalarFunction
implements BlockLoaderExpression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Length", Length::new);

    @FunctionInfo(returnType={"integer"}, description="Returns the character length of a string.", note="All strings are in UTF-8, so a single character can use multiple bytes.", examples={@Example(file="eval", tag="length")})
    public Length(Source source, @Param(name="string", type={"keyword", "text"}, description="String expression. If `null`, the function returns `null`.") Expression field) {
        super(source, field);
    }

    private Length(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Length.ENTRY.name;
    }

    @Override
    public DataType dataType() {
        return DataType.INTEGER;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isString(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    static int process(BytesRef val) {
        return UnicodeUtil.codePointCount((BytesRef)val);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new Length(this.source(), newChildren.get(0));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Length::new, this.field());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return new LengthEvaluator.Factory(this.source(), toEvaluator.apply(this.field()));
    }

    @Override
    public BlockLoaderExpression.PushedBlockLoaderExpression tryPushToFieldLoading(SearchStats stats) {
        Expression expression = this.field;
        if (expression instanceof FieldAttribute) {
            FieldAttribute f = (FieldAttribute)expression;
            BlockLoaderWarnings warnings = new BlockLoaderWarnings(DriverContext.WarningsMode.COLLECT, this.source());
            return new BlockLoaderExpression.PushedBlockLoaderExpression(f, (BlockLoaderFunctionConfig)new BlockLoaderFunctionConfig.JustWarnings(BlockLoaderFunctionConfig.Function.LENGTH, (Warnings)warnings));
        }
        return null;
    }
}

