/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.BitLengthEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class BitLength
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "BitLength", BitLength::new);

    @FunctionInfo(returnType={"integer"}, description="Returns the bit length of a string.", note="All strings are in UTF-8, so a single character can use multiple bytes.", examples={@Example(file="docs", tag="bitLength")})
    public BitLength(Source source, @Param(name="string", type={"keyword", "text"}, description="String expression. If `null`, the function returns `null`.") Expression field) {
        super(source, field);
    }

    private BitLength(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field());
    }

    public String getWriteableName() {
        return BitLength.ENTRY.name;
    }

    @Override
    public DataType dataType() {
        return DataType.INTEGER;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return !this.childrenResolved() ? new Expression.TypeResolution("Unresolved children") : TypeResolutions.isString(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    static int process(BytesRef val) {
        return Math.multiplyExact(val.length, 8);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new BitLength(this.source(), newChildren.get(0));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, BitLength::new, this.field());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return new BitLengthEvaluator.Factory(this.source(), toEvaluator.apply(this.field()));
    }
}

