/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StXMin;

public final class StXMinFromWKBGeoEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(StXMinFromWKBGeoEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator wkbBlock;
    private final DriverContext driverContext;
    private Warnings warnings;

    public StXMinFromWKBGeoEvaluator(Source source, EvalOperator.ExpressionEvaluator wkbBlock, DriverContext driverContext) {
        this.source = source;
        this.wkbBlock = wkbBlock;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock wkbBlockBlock = (BytesRefBlock)this.wkbBlock.eval(page);){
            DoubleBlock doubleBlock = this.eval(page.getPositionCount(), wkbBlockBlock);
            return doubleBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.wkbBlock.baseRamBytesUsed();
    }

    public DoubleBlock eval(int positionCount, BytesRefBlock wkbBlockBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!wkbBlockBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                try {
                    StXMin.fromWellKnownBinaryGeo(result, p, wkbBlockBlock);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public String toString() {
        return "StXMinFromWKBGeoEvaluator[wkbBlock=" + String.valueOf(this.wkbBlock) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.wkbBlock);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory wkbBlock;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory wkbBlock) {
            this.source = source;
            this.wkbBlock = wkbBlock;
        }

        public StXMinFromWKBGeoEvaluator get(DriverContext context) {
            return new StXMinFromWKBGeoEvaluator(this.source, this.wkbBlock.get(context), context);
        }

        public String toString() {
            return "StXMinFromWKBGeoEvaluator[wkbBlock=" + String.valueOf(this.wkbBlock) + "]";
        }
    }
}

