/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StX;

public final class StXFromCartesianDocValuesEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(StXFromCartesianDocValuesEvaluator.class);
    private final EvalOperator.ExpressionEvaluator encoded;

    public StXFromCartesianDocValuesEvaluator(Source source, EvalOperator.ExpressionEvaluator encoded, DriverContext driverContext) {
        super(driverContext, source);
        this.encoded = encoded;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.encoded;
    }

    @Override
    public Block evalVector(Vector v) {
        LongVector vector = (LongVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            try {
                return this.driverContext.blockFactory().newConstantDoubleBlockWith(this.evalValue(vector, 0), positionCount);
            }
            catch (IllegalArgumentException e) {
                this.registerException(e);
                return this.driverContext.blockFactory().newConstantNullBlock(positionCount);
            }
        }
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    builder.appendDouble(this.evalValue(vector, p));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.registerException(e);
                    builder.appendNull();
                }
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    private double evalValue(LongVector container, int index) {
        long value = container.getLong(index);
        return StX.fromCartesianDocValues(value);
    }

    @Override
    public Block evalBlock(Block b) {
        LongBlock block = (LongBlock)b;
        int positionCount = block.getPositionCount();
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    try {
                        double value = this.evalValue(block, i);
                        if (!positionOpened && valueCount > 1) {
                            builder.beginPositionEntry();
                            positionOpened = true;
                        }
                        builder.appendDouble(value);
                        valuesAppended = true;
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        this.registerException(e);
                    }
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    private double evalValue(LongBlock container, int index) {
        long value = container.getLong(index);
        return StX.fromCartesianDocValues(value);
    }

    public String toString() {
        return "StXFromCartesianDocValuesEvaluator[encoded=" + String.valueOf(this.encoded) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.encoded);
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.encoded.baseRamBytesUsed();
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory encoded;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory encoded) {
            this.source = source;
            this.encoded = encoded;
        }

        public StXFromCartesianDocValuesEvaluator get(DriverContext context) {
            return new StXFromCartesianDocValuesEvaluator(this.source, this.encoded.get(context), context);
        }

        public String toString() {
            return "StXFromCartesianDocValuesEvaluator[encoded=" + String.valueOf(this.encoded) + "]";
        }
    }
}

