/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialDocValuesFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public abstract class SpatialUnaryDocValuesFunction
extends SpatialDocValuesFunction {
    protected SpatialUnaryDocValuesFunction(Source source, Expression spatialField, boolean spatialDocValues) {
        super(source, List.of(spatialField), spatialDocValues);
    }

    protected SpatialUnaryDocValuesFunction(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), false);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return EsqlTypeResolutions.isSpatial(this.spatialField(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    public final void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.spatialField());
    }

    @Override
    public final Expression spatialField() {
        return (Expression)this.children().getFirst();
    }
}

