/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.utils.Geohash;
import org.elasticsearch.h3.H3;
import org.elasticsearch.index.mapper.ShapeIndexer;
import org.elasticsearch.lucene.spatial.Component2DVisitor;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.GeometryDocValueReader;
import org.elasticsearch.lucene.spatial.TriangleTreeVisitor;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.TypedAttribute;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Check;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.BinarySpatialFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialEvaluatorFactory;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesUtils;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.querydsl.query.SpatialRelatesQuery;

public abstract class SpatialRelatesFunction
extends BinarySpatialFunction
implements EvaluatorMapper,
SpatialEvaluatorFactory.SpatialSourceSupplier,
TranslationAware,
SurrogateExpression {
    protected SpatialRelatesFunction(Source source, Expression left, Expression right, boolean leftDocValues, boolean rightDocValues) {
        super(source, left, right, leftDocValues, rightDocValues, false, false);
    }

    protected SpatialRelatesFunction(Source source, Expression left, Expression right, boolean leftDocValues, boolean rightDocValues, boolean supportsGrid) {
        super(source, left, right, leftDocValues, rightDocValues, false, supportsGrid);
    }

    protected SpatialRelatesFunction(StreamInput in, boolean leftDocValues, boolean rightDocValues) throws IOException {
        super(in, leftDocValues, rightDocValues, false, false);
    }

    protected SpatialRelatesFunction(StreamInput in, boolean leftDocValues, boolean rightDocValues, boolean supportsGrid) throws IOException {
        super(in, leftDocValues, rightDocValues, false, supportsGrid);
    }

    public abstract ShapeRelation queryRelation();

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    abstract Map<SpatialEvaluatorFactory.SpatialEvaluatorKey, SpatialEvaluatorFactory<?, ?>> evaluatorRules();

    @Override
    public SpatialRelatesFunction surrogate() {
        return this;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return SpatialEvaluatorFactory.makeSpatialEvaluator(this, this.evaluatorRules(), toEvaluator);
    }

    @Override
    public TranslationAware.Translatable translatable(LucenePushdownPredicates pushdownPredicates) {
        return super.translatable(pushdownPredicates);
    }

    @Override
    public Query asQuery(LucenePushdownPredicates pushdownPredicates, TranslatorHandler handler) {
        if (this.left().foldable()) {
            SpatialRelatesFunction.checkSpatialRelatesFunction(this.left(), this.queryRelation());
            return this.translate(handler, this.right(), this.left());
        }
        SpatialRelatesFunction.checkSpatialRelatesFunction(this.right(), this.queryRelation());
        return this.translate(handler, this.left(), this.right());
    }

    private static void checkSpatialRelatesFunction(Expression constantExpression, ShapeRelation queryRelation) {
        Check.isTrue(constantExpression.foldable(), "Line {}:{}: Comparisons against fields are not (currently) supported; offender [{}] in [ST_{}]", constantExpression.sourceLocation().getLineNumber(), constantExpression.sourceLocation().getColumnNumber(), Expressions.name(constantExpression), queryRelation);
    }

    private Query translate(TranslatorHandler handler, Expression spatialExpression, Expression constantExpression) {
        TypedAttribute attribute = LucenePushdownPredicates.checkIsPushableAttribute(spatialExpression);
        String name = handler.nameOf(attribute);
        try {
            Geometry shape = SpatialRelatesUtils.makeGeometryFromLiteral(constantExpression);
            return new SpatialRelatesQuery(this.source(), name, this.queryRelation(), shape, attribute.dataType());
        }
        catch (IllegalArgumentException e) {
            throw new QlIllegalArgumentException(e.getMessage(), (Throwable)e);
        }
    }

    protected static class SpatialRelations
    extends BinarySpatialFunction.BinarySpatialComparator<Boolean> {
        protected final ShapeField.QueryRelation queryRelation;
        protected final ShapeIndexer shapeIndexer;

        protected SpatialRelations(ShapeField.QueryRelation queryRelation, SpatialCoordinateTypes spatialCoordinateType, CoordinateEncoder encoder, ShapeIndexer shapeIndexer) {
            super(spatialCoordinateType, encoder);
            this.queryRelation = queryRelation;
            this.shapeIndexer = shapeIndexer;
        }

        @Override
        protected Boolean compare(BytesRef left, BytesRef right) throws IOException {
            return this.geometryRelatesGeometry(left, right);
        }

        protected boolean geometryRelatesGeometry(BytesRef left, BytesRef right) throws IOException {
            Component2D rightComponent2D = SpatialRelatesUtils.asLuceneComponent2D(this.crsType, this.fromBytesRef(right));
            return this.geometryRelatesGeometry(SpatialRelatesUtils.asGeometryDocValueReader(this.coordinateEncoder, this.shapeIndexer, this.fromBytesRef(left)), rightComponent2D);
        }

        protected boolean geometryRelatesGeometry(GeometryDocValueReader reader, Component2D rightComponent2D) throws IOException {
            Component2DVisitor visitor = Component2DVisitor.getVisitor((Component2D)rightComponent2D, (ShapeField.QueryRelation)this.queryRelation, (CoordinateEncoder)this.coordinateEncoder);
            reader.visit((TriangleTreeVisitor)visitor);
            return visitor.matches();
        }

        protected void processSourceAndConstantGrid(BooleanBlock.Builder builder, int position, BytesRefBlock wkb, long gridId, DataType gridType) {
            if (wkb.getValueCount(position) < 1) {
                builder.appendNull();
            } else {
                builder.appendBoolean(this.compareGeometryAndGrid(SpatialRelatesUtils.asGeometry(wkb, position), gridId, gridType));
            }
        }

        protected void processSourceAndSourceGrid(BooleanBlock.Builder builder, int position, BytesRefBlock wkb, LongBlock gridIds, DataType gridType) {
            if (wkb.getValueCount(position) < 1 || gridIds.getValueCount(position) < 1) {
                builder.appendNull();
            } else {
                builder.appendBoolean(this.compareGeometryAndGrid(SpatialRelatesUtils.asGeometry(wkb, position), gridIds.getLong(position), gridType));
            }
        }

        protected boolean compareGeometryAndGrid(Geometry geometry, long gridId, DataType gridType) {
            if (geometry instanceof Point) {
                Point point = (Point)geometry;
                long geoGridId = this.getGridId(point, gridId, gridType);
                return switch (this.queryRelation) {
                    case ShapeField.QueryRelation.INTERSECTS -> {
                        if (gridId == geoGridId) {
                            yield true;
                        }
                        yield false;
                    }
                    case ShapeField.QueryRelation.DISJOINT -> {
                        if (gridId != geoGridId) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> throw new IllegalArgumentException("Unsupported grid relation: " + String.valueOf(this.queryRelation));
                };
            }
            throw new IllegalArgumentException("Unsupported grid intersection geometry type: " + geometry.getClass().getSimpleName() + "; expected Point");
        }

        protected void processGeoPointDocValuesAndConstantGrid(BooleanBlock.Builder builder, int position, LongBlock encodedPoint, long gridId, DataType gridType) {
            if (encodedPoint.getValueCount(position) < 1) {
                builder.appendNull();
            } else {
                Point point = this.spatialCoordinateType.longAsPoint(encodedPoint.getLong(position));
                long geoGridId = this.getGridId(point, gridId, gridType);
                builder.appendBoolean(gridId == geoGridId);
            }
        }

        protected void processGeoPointDocValuesAndSourceGrid(BooleanBlock.Builder builder, int position, LongBlock encodedPoint, LongBlock gridIds, DataType gridType) {
            if (encodedPoint.getValueCount(position) < 1 || gridIds.getValueCount(position) < 1) {
                builder.appendNull();
            } else {
                long geoGridId;
                Point point = this.spatialCoordinateType.longAsPoint(encodedPoint.getLong(position));
                long gridId = gridIds.getLong(position);
                builder.appendBoolean(gridId == (geoGridId = this.getGridId(point, gridId, gridType)));
            }
        }

        private long getGridId(Point point, long gridId, DataType gridType) {
            return switch (gridType) {
                case DataType.GEOHASH -> Geohash.longEncode((double)point.getX(), (double)point.getY(), (int)Geohash.stringEncode((long)gridId).length());
                case DataType.GEOTILE -> GeoTileUtils.longEncode((double)point.getX(), (double)point.getY(), (int)Integer.parseInt(GeoTileUtils.stringEncode((long)gridId).split("/")[0]));
                case DataType.GEOHEX -> H3.geoToH3((double)point.getY(), (double)point.getX(), (int)H3.getResolution((long)gridId));
                default -> throw new IllegalArgumentException("Unsupported grid type: " + String.valueOf((Object)gridType) + "; expected GEOHASH, GEOTILE, or GEOHEX");
            };
        }

        protected void processSourceAndConstant(BooleanBlock.Builder builder, int position, BytesRefBlock left, Component2D right) throws IOException {
            if (left.getValueCount(position) < 1) {
                builder.appendNull();
            } else {
                GeometryDocValueReader reader = SpatialRelatesUtils.asGeometryDocValueReader(this.coordinateEncoder, this.shapeIndexer, left, position);
                builder.appendBoolean(this.geometryRelatesGeometry(reader, right));
            }
        }

        protected void processSourceAndSource(BooleanBlock.Builder builder, int position, BytesRefBlock left, BytesRefBlock right) throws IOException {
            if (left.getValueCount(position) < 1 || right.getValueCount(position) < 1) {
                builder.appendNull();
            } else {
                GeometryDocValueReader reader = SpatialRelatesUtils.asGeometryDocValueReader(this.coordinateEncoder, this.shapeIndexer, left, position);
                Component2D component2D = SpatialRelatesUtils.asLuceneComponent2D(this.crsType, right, position);
                builder.appendBoolean(this.geometryRelatesGeometry(reader, component2D));
            }
        }

        protected void processPointDocValuesAndConstant(BooleanBlock.Builder builder, int position, LongBlock leftValue, Component2D rightValue) throws IOException {
            if (leftValue.getValueCount(position) < 1) {
                builder.appendNull();
            } else {
                GeometryDocValueReader reader = SpatialRelatesUtils.asGeometryDocValueReader(this.coordinateEncoder, this.shapeIndexer, leftValue, position, arg_0 -> ((SpatialCoordinateTypes)this.spatialCoordinateType).longAsPoint(arg_0));
                builder.appendBoolean(this.geometryRelatesGeometry(reader, rightValue));
            }
        }

        protected void processPointDocValuesAndSource(BooleanBlock.Builder builder, int position, LongBlock leftValue, BytesRefBlock rightValue) throws IOException {
            if (leftValue.getValueCount(position) < 1 || rightValue.getValueCount(position) < 1) {
                builder.appendNull();
            } else {
                GeometryDocValueReader reader = SpatialRelatesUtils.asGeometryDocValueReader(this.coordinateEncoder, this.shapeIndexer, leftValue, position, arg_0 -> ((SpatialCoordinateTypes)this.spatialCoordinateType).longAsPoint(arg_0));
                Component2D component2D = SpatialRelatesUtils.asLuceneComponent2D(this.crsType, rightValue, position);
                builder.appendBoolean(this.geometryRelatesGeometry(reader, component2D));
            }
        }
    }
}

