/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialIntersects;

public final class SpatialIntersectsGeoPointDocValuesAndSourceGridEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SpatialIntersectsGeoPointDocValuesAndSourceGridEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator encodedPoints;
    private final EvalOperator.ExpressionEvaluator gridIds;
    private final DataType gridType;
    private final DriverContext driverContext;
    private Warnings warnings;

    public SpatialIntersectsGeoPointDocValuesAndSourceGridEvaluator(Source source, EvalOperator.ExpressionEvaluator encodedPoints, EvalOperator.ExpressionEvaluator gridIds, DataType gridType, DriverContext driverContext) {
        this.source = source;
        this.encodedPoints = encodedPoints;
        this.gridIds = gridIds;
        this.gridType = gridType;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock encodedPointsBlock = (LongBlock)this.encodedPoints.eval(page);){
            BooleanBlock booleanBlock;
            block12: {
                LongBlock gridIdsBlock = (LongBlock)this.gridIds.eval(page);
                try {
                    booleanBlock = this.eval(page.getPositionCount(), encodedPointsBlock, gridIdsBlock);
                    if (gridIdsBlock == null) break block12;
                }
                catch (Throwable throwable) {
                    if (gridIdsBlock != null) {
                        try {
                            gridIdsBlock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                gridIdsBlock.close();
            }
            return booleanBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.encodedPoints.baseRamBytesUsed();
        return baseRamBytesUsed += this.gridIds.baseRamBytesUsed();
    }

    public BooleanBlock eval(int positionCount, LongBlock encodedPointsBlock, LongBlock gridIdsBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!encodedPointsBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (!gridIdsBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                try {
                    SpatialIntersects.processGeoPointDocValuesAndSourceGrid(result, p, encodedPointsBlock, gridIdsBlock, this.gridType);
                    continue;
                }
                catch (IOException | IllegalArgumentException e) {
                    this.warnings().registerException(e);
                    result.appendNull();
                }
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public String toString() {
        return "SpatialIntersectsGeoPointDocValuesAndSourceGridEvaluator[encodedPoints=" + String.valueOf(this.encodedPoints) + ", gridIds=" + String.valueOf(this.gridIds) + ", gridType=" + String.valueOf((Object)this.gridType) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.encodedPoints, this.gridIds});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory encodedPoints;
        private final EvalOperator.ExpressionEvaluator.Factory gridIds;
        private final DataType gridType;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory encodedPoints, EvalOperator.ExpressionEvaluator.Factory gridIds, DataType gridType) {
            this.source = source;
            this.encodedPoints = encodedPoints;
            this.gridIds = gridIds;
            this.gridType = gridType;
        }

        public SpatialIntersectsGeoPointDocValuesAndSourceGridEvaluator get(DriverContext context) {
            return new SpatialIntersectsGeoPointDocValuesAndSourceGridEvaluator(this.source, this.encodedPoints.get(context), this.gridIds.get(context), this.gridType, context);
        }

        public String toString() {
            return "SpatialIntersectsGeoPointDocValuesAndSourceGridEvaluator[encodedPoints=" + String.valueOf(this.encodedPoints) + ", gridIds=" + String.valueOf(this.gridIds) + ", gridType=" + String.valueOf((Object)this.gridType) + "]";
        }
    }
}

