/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.license.License;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.esql.LicenseAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialDocValuesFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public abstract class SpatialGridFunction
extends SpatialDocValuesFunction
implements OptionalArgument,
LicenseAware {
    protected final Expression spatialField;
    protected final Expression parameter;
    protected final Expression bounds;

    protected SpatialGridFunction(Source source, Expression spatialField, Expression parameter, Expression bounds, boolean spatialDocValues) {
        super(source, bounds == null ? Arrays.asList(spatialField, parameter) : Arrays.asList(spatialField, parameter, bounds), spatialDocValues);
        this.spatialField = spatialField;
        this.parameter = parameter;
        this.bounds = bounds;
    }

    protected SpatialGridFunction(StreamInput in, boolean spatialDocValues) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readOptionalNamedWriteable(Expression.class), spatialDocValues);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.spatialField);
        out.writeNamedWriteable((NamedWriteable)this.parameter);
        out.writeOptionalNamedWriteable((NamedWriteable)this.bounds);
    }

    @Override
    public boolean licenseCheck(XPackLicenseState state) {
        return switch (this.spatialField().dataType()) {
            case DataType.GEO_SHAPE, DataType.CARTESIAN_SHAPE -> state.isAllowedByLicense(License.OperationMode.PLATINUM);
            default -> true;
        };
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = SpatialGridFunction.isGeoPoint(this.spatialField(), this.sourceText());
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isType(this.parameter, t -> t.equals((Object)DataType.INTEGER), this.sourceText(), TypeResolutions.ParamOrdinal.SECOND, DataType.INTEGER.typeName());
        if (resolution.unresolved()) {
            return resolution;
        }
        if (this.bounds() != null && (resolution = SpatialGridFunction.isGeoshape(this.bounds(), this.sourceText())).unresolved()) {
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    protected static Expression.TypeResolution isGeoPoint(Expression e, String operationName) {
        return TypeResolutions.isType(e, t -> t.equals((Object)DataType.GEO_POINT), operationName, TypeResolutions.ParamOrdinal.FIRST, DataType.GEO_POINT.typeName());
    }

    protected static Expression.TypeResolution isGeoshape(Expression e, String operationName) {
        return TypeResolutions.isType(e, t -> t.equals((Object)DataType.GEO_SHAPE), operationName, TypeResolutions.ParamOrdinal.THIRD, DataType.GEO_SHAPE.typeName());
    }

    protected static Rectangle asRectangle(BytesRef boundsBytesRef) {
        Geometry geometry = SpatialCoordinateTypes.GEO.wkbToGeometry(boundsBytesRef);
        if (geometry instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)geometry;
            return rectangle;
        }
        throw new IllegalArgumentException("Bounds geometry type '" + geometry.getClass().getSimpleName() + "' is not an envelope");
    }

    protected static GeoBoundingBox asGeoBoundingBox(Object bounds) {
        if (bounds instanceof BytesRef) {
            BytesRef boundsBytesRef = (BytesRef)bounds;
            return SpatialGridFunction.asGeoBoundingBox(SpatialGridFunction.asRectangle(boundsBytesRef));
        }
        throw new IllegalArgumentException("Cannot determine envelope of bounds geometry of type " + bounds.getClass().getSimpleName());
    }

    protected static GeoBoundingBox asGeoBoundingBox(Rectangle rectangle) {
        return new GeoBoundingBox(new GeoPoint(rectangle.getMaxLat(), rectangle.getMinLon()), new GeoPoint(rectangle.getMinLat(), rectangle.getMaxLon()));
    }

    @Override
    public final SpatialGridFunction replaceChildren(List<Expression> newChildren) {
        Expression newSpatialField = newChildren.get(0);
        Expression newParameter = newChildren.get(1);
        Expression newBounds = newChildren.size() > 2 ? newChildren.get(2) : null;
        return this.spatialField.equals(newSpatialField) && this.parameter.equals(newParameter) && (this.bounds == null && newBounds == null || this.bounds != null && this.bounds.equals(newBounds)) ? this : this.replaceChildren(newSpatialField, newParameter, newBounds);
    }

    protected abstract SpatialGridFunction replaceChildren(Expression var1, Expression var2, Expression var3);

    @Override
    public Expression spatialField() {
        return this.spatialField;
    }

    public Expression parameter() {
        return this.parameter;
    }

    public Expression bounds() {
        return this.bounds;
    }

    @Override
    public boolean foldable() {
        return this.spatialField.foldable() && this.parameter.foldable() && (this.bounds == null || this.bounds.foldable());
    }

    protected static void addGrids(LongBlock.Builder results, List<Long> gridIds) {
        if (gridIds.isEmpty()) {
            results.appendNull();
        } else if (gridIds.size() == 1) {
            results.appendLong(gridIds.getFirst().longValue());
        } else {
            results.beginPositionEntry();
            for (long gridId : gridIds) {
                results.appendLong(gridId);
            }
            results.endPositionEntry();
        }
    }

    protected static void fromWKB(LongBlock.Builder results, int position, BytesRefBlock wkbBlock, int precision, UnboundedGrid unboundedGrid) {
        int valueCount = wkbBlock.getValueCount(position);
        if (valueCount < 1) {
            results.appendNull();
        } else {
            BytesRef scratch = new BytesRef();
            int firstValueIndex = wkbBlock.getFirstValueIndex(position);
            if (valueCount == 1) {
                results.appendLong(unboundedGrid.calculateGridId(SpatialCoordinateTypes.GEO.wkbAsPoint(wkbBlock.getBytesRef(firstValueIndex, scratch)), precision));
            } else {
                results.beginPositionEntry();
                for (int i = 0; i < valueCount; ++i) {
                    results.appendLong(unboundedGrid.calculateGridId(SpatialCoordinateTypes.GEO.wkbAsPoint(wkbBlock.getBytesRef(firstValueIndex + i, scratch)), precision));
                }
                results.endPositionEntry();
            }
        }
    }

    protected static void fromEncodedLong(LongBlock.Builder results, int position, LongBlock encoded, int precision, UnboundedGrid unboundedGrid) {
        int valueCount = encoded.getValueCount(position);
        if (valueCount < 1) {
            results.appendNull();
        } else {
            int firstValueIndex = encoded.getFirstValueIndex(position);
            if (valueCount == 1) {
                results.appendLong(unboundedGrid.calculateGridId(SpatialCoordinateTypes.GEO.longAsPoint(encoded.getLong(firstValueIndex)), precision));
            } else {
                results.beginPositionEntry();
                for (int i = 0; i < valueCount; ++i) {
                    results.appendLong(unboundedGrid.calculateGridId(SpatialCoordinateTypes.GEO.longAsPoint(encoded.getLong(firstValueIndex + i)), precision));
                }
                results.endPositionEntry();
            }
        }
    }

    protected static void fromWKB(LongBlock.Builder results, int position, BytesRefBlock wkbBlock, BoundedGrid bounds) {
        int valueCount = wkbBlock.getValueCount(position);
        if (valueCount < 1) {
            results.appendNull();
        } else {
            BytesRef scratch = new BytesRef();
            int firstValueIndex = wkbBlock.getFirstValueIndex(position);
            if (valueCount == 1) {
                long grid = bounds.calculateGridId(SpatialCoordinateTypes.GEO.wkbAsPoint(wkbBlock.getBytesRef(firstValueIndex, scratch)));
                if (grid < 0L) {
                    results.appendNull();
                } else {
                    results.appendLong(grid);
                }
            } else {
                ArrayList<Long> gridIds = new ArrayList<Long>(valueCount);
                for (int i = 0; i < valueCount; ++i) {
                    long grid = bounds.calculateGridId(SpatialCoordinateTypes.GEO.wkbAsPoint(wkbBlock.getBytesRef(firstValueIndex + i, scratch)));
                    if (grid < 0L) continue;
                    gridIds.add(grid);
                }
                SpatialGridFunction.addGrids(results, gridIds);
            }
        }
    }

    protected static void fromEncodedLong(LongBlock.Builder results, int position, LongBlock encoded, BoundedGrid bounds) {
        int valueCount = encoded.getValueCount(position);
        if (valueCount < 1) {
            results.appendNull();
        } else {
            int firstValueIndex = encoded.getFirstValueIndex(position);
            if (valueCount == 1) {
                long grid = bounds.calculateGridId(SpatialCoordinateTypes.GEO.longAsPoint(encoded.getLong(firstValueIndex)));
                if (grid < 0L) {
                    results.appendNull();
                } else {
                    results.appendLong(grid);
                }
            } else {
                ArrayList<Long> gridIds = new ArrayList<Long>(valueCount);
                for (int i = 0; i < valueCount; ++i) {
                    long grid = bounds.calculateGridId(SpatialCoordinateTypes.GEO.longAsPoint(encoded.getLong(firstValueIndex + i)));
                    if (grid < 0L) continue;
                    gridIds.add(grid);
                }
                SpatialGridFunction.addGrids(results, gridIds);
            }
        }
    }

    public static interface UnboundedGrid {
        public long calculateGridId(Point var1, int var2);
    }

    protected static interface BoundedGrid {
        public long calculateGridId(Point var1);

        public int precision();
    }
}

