/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.SpatialEnvelopeVisitor;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;

public class SpatialEnvelopeResults<T extends Block.Builder> {
    void fromWellKnownBinary(T results, int p, BytesRefBlock wkbBlock, SpatialEnvelopeVisitor.PointVisitor pointVisitor, BiConsumer<T, Rectangle> rectangleResult) {
        int valueCount = wkbBlock.getValueCount(p);
        if (valueCount == 0) {
            results.appendNull();
            return;
        }
        BytesRef scratch = new BytesRef();
        SpatialEnvelopeVisitor visitor = new SpatialEnvelopeVisitor(pointVisitor);
        int firstValueIndex = wkbBlock.getFirstValueIndex(p);
        for (int i = 0; i < valueCount; ++i) {
            BytesRef wkb = wkbBlock.getBytesRef(firstValueIndex + i, scratch);
            Geometry geometry = SpatialCoordinateTypes.UNSPECIFIED.wkbToGeometry(wkb);
            geometry.visit((GeometryVisitor)visitor);
        }
        if (pointVisitor.isValid()) {
            rectangleResult.accept(results, pointVisitor.getResult());
            return;
        }
        throw new IllegalArgumentException("Cannot determine envelope of geometry");
    }

    void fromDocValues(T results, int p, LongBlock encodedBlock, SpatialEnvelopeVisitor.PointVisitor pointVisitor, SpatialCoordinateTypes spatialCoordinateType, BiConsumer<T, Rectangle> rectangleResult) {
        int valueCount = encodedBlock.getValueCount(p);
        if (valueCount == 0) {
            results.appendNull();
            return;
        }
        int firstValueIndex = encodedBlock.getFirstValueIndex(p);
        for (int i = 0; i < valueCount; ++i) {
            long encoded = encodedBlock.getLong(firstValueIndex + i);
            pointVisitor.visitPoint(spatialCoordinateType.decodeX(encoded), spatialCoordinateType.decodeY(encoded));
        }
        if (pointVisitor.isValid()) {
            rectangleResult.accept(results, pointVisitor.getResult());
            return;
        }
        throw new IllegalArgumentException("Cannot determine envelope of geometry");
    }

    void fromDocValuesLinear(DoubleBlock.Builder results, int p, LongBlock encodedBlock, double initialValue, BiFunction<Double, Long, Double> reducer) {
        int valueCount = encodedBlock.getValueCount(p);
        if (valueCount == 0) {
            results.appendNull();
            return;
        }
        double current = initialValue;
        int firstValueIndex = encodedBlock.getFirstValueIndex(p);
        for (int i = 0; i < valueCount; ++i) {
            long encoded = encodedBlock.getLong(firstValueIndex + i);
            current = reducer.apply(current, encoded);
        }
        if (Double.isFinite(current)) {
            results.appendDouble(current);
            return;
        }
        throw new IllegalArgumentException("Cannot determine envelope of geometry");
    }
}

