/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialDisjoint;

public final class SpatialDisjointGeoSourceAndSourceGridEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SpatialDisjointGeoSourceAndSourceGridEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator wkb;
    private final EvalOperator.ExpressionEvaluator gridId;
    private final DataType gridType;
    private final DriverContext driverContext;
    private Warnings warnings;

    public SpatialDisjointGeoSourceAndSourceGridEvaluator(Source source, EvalOperator.ExpressionEvaluator wkb, EvalOperator.ExpressionEvaluator gridId, DataType gridType, DriverContext driverContext) {
        this.source = source;
        this.wkb = wkb;
        this.gridId = gridId;
        this.gridType = gridType;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock wkbBlock = (BytesRefBlock)this.wkb.eval(page);){
            BooleanBlock booleanBlock;
            block12: {
                LongBlock gridIdBlock = (LongBlock)this.gridId.eval(page);
                try {
                    booleanBlock = this.eval(page.getPositionCount(), wkbBlock, gridIdBlock);
                    if (gridIdBlock == null) break block12;
                }
                catch (Throwable throwable) {
                    if (gridIdBlock != null) {
                        try {
                            gridIdBlock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                gridIdBlock.close();
            }
            return booleanBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.wkb.baseRamBytesUsed();
        return baseRamBytesUsed += this.gridId.baseRamBytesUsed();
    }

    public BooleanBlock eval(int positionCount, BytesRefBlock wkbBlock, LongBlock gridIdBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!wkbBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (!gridIdBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                try {
                    SpatialDisjoint.processGeoSourceAndSourceGrid(result, p, wkbBlock, gridIdBlock, this.gridType);
                    continue;
                }
                catch (IOException | IllegalArgumentException e) {
                    this.warnings().registerException(e);
                    result.appendNull();
                }
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public String toString() {
        return "SpatialDisjointGeoSourceAndSourceGridEvaluator[wkb=" + String.valueOf(this.wkb) + ", gridId=" + String.valueOf(this.gridId) + ", gridType=" + String.valueOf((Object)this.gridType) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.wkb, this.gridId});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory wkb;
        private final EvalOperator.ExpressionEvaluator.Factory gridId;
        private final DataType gridType;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory wkb, EvalOperator.ExpressionEvaluator.Factory gridId, DataType gridType) {
            this.source = source;
            this.wkb = wkb;
            this.gridId = gridId;
            this.gridType = gridType;
        }

        public SpatialDisjointGeoSourceAndSourceGridEvaluator get(DriverContext context) {
            return new SpatialDisjointGeoSourceAndSourceGridEvaluator(this.source, this.wkb.get(context), this.gridId.get(context), this.gridType, context);
        }

        public String toString() {
            return "SpatialDisjointGeoSourceAndSourceGridEvaluator[wkb=" + String.valueOf(this.wkb) + ", gridId=" + String.valueOf(this.gridId) + ", gridType=" + String.valueOf((Object)this.gridType) + "]";
        }
    }
}

