/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.score;

import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.script.ScoreScriptUtils;
import org.elasticsearch.xpack.esql.capabilities.PostOptimizationVerificationAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.MapExpression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.MapParam;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Options;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.score.DecayCartesianPointEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.score.DecayDateNanosEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.score.DecayDatetimeEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.score.DecayDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.score.DecayGeoPointEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.score.DecayIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.score.DecayLongEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Decay
extends EsqlScalarFunction
implements OptionalArgument,
PostOptimizationVerificationAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Decay", Decay::new);
    public static final String ORIGIN = "origin";
    public static final String SCALE = "scale";
    public static final String OFFSET = "offset";
    public static final String DECAY = "decay";
    public static final String TYPE = "type";
    private static final Map<String, Collection<DataType>> ALLOWED_OPTIONS = Map.of("offset", Set.of(DataType.TIME_DURATION, DataType.INTEGER, DataType.LONG, DataType.DOUBLE, DataType.KEYWORD, DataType.TEXT), "decay", Set.of(DataType.DOUBLE), "type", Set.of(DataType.KEYWORD));
    private static final Integer DEFAULT_INTEGER_OFFSET = 0;
    private static final Long DEFAULT_LONG_OFFSET = 0L;
    private static final Double DEFAULT_DOUBLE_OFFSET = 0.0;
    private static final BytesRef DEFAULT_GEO_POINT_OFFSET = new BytesRef((CharSequence)"0m");
    private static final Double DEFAULT_CARTESIAN_POINT_OFFSET = 0.0;
    private static final Long DEFAULT_TEMPORAL_OFFSET = 0L;
    private static final Double DEFAULT_DECAY = 0.5;
    private static final BytesRef DEFAULT_FUNCTION = new BytesRef((CharSequence)"linear");
    private final Expression origin;
    private final Expression value;
    private final Expression scale;
    private final Expression options;
    private final Map<String, Object> resolvedOptions;

    @FunctionInfo(returnType={"double"}, preview=true, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.3.0")}, description="Calculates a relevance score that decays based on the distance of a numeric, spatial or date type value from a target origin, using configurable decay functions.", detailedDescription="`DECAY` calculates a score between 0 and 1 based on how far a field value is from a specified origin point (called distance).\nThe distance can be a numeric distance, spatial distance or temporal distance depending on the specific data type.\n\n`DECAY` can use <<esql-function-named-params,function named parameters>> to specify additional `options`\nfor the decay function.\n\nFor spatial queries, scale and offset for geo points use distance units (e.g., \"10km\", \"5mi\"),\nwhile cartesian points use numeric values. For date queries, scale and offset use time_duration values.\nFor numeric queries you also use numeric values.\n", examples={@Example(file="decay", tag="decay")})
    public Decay(Source source, @Param(name="value", type={"double", "integer", "long", "date", "date_nanos", "geo_point", "cartesian_point"}, description="The input value to apply decay scoring to.") Expression value, @Param(name="origin", type={"double", "integer", "long", "date", "date_nanos", "geo_point", "cartesian_point"}, description="Central point from which the distances are calculated.") Expression origin, @Param(name="scale", type={"double", "integer", "long", "time_duration", "keyword", "text"}, description="Distance from the origin where the function returns the decay value.") Expression scale, @MapParam(name="options", params={@MapParam.MapParamEntry(name="offset", type={"double", "integer", "long", "time_duration", "keyword", "text"}, description="Distance from the origin where no decay occurs."), @MapParam.MapParamEntry(name="decay", type={"double"}, description="Multiplier value returned at the scale distance from the origin."), @MapParam.MapParamEntry(name="type", type={"keyword"}, description="Decay function to use: linear, exponential or gaussian.")}, optional=true) Expression options) {
        super(source, options != null ? List.of(value, origin, scale, options) : List.of(value, origin, scale));
        this.value = value;
        this.origin = origin;
        this.scale = scale;
        this.options = options;
        this.resolvedOptions = new HashMap<String, Object>();
    }

    private Decay(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readOptionalNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.value);
        out.writeNamedWriteable((NamedWriteable)this.origin);
        out.writeNamedWriteable((NamedWriteable)this.scale);
        out.writeOptionalNamedWriteable((NamedWriteable)this.options);
    }

    public String getWriteableName() {
        return Decay.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return this.validateValue().and(() -> Options.resolveWithMultipleDataTypesAllowed(this.options, this.source(), TypeResolutions.ParamOrdinal.FOURTH, ALLOWED_OPTIONS)).and(() -> this.validateOriginScaleAndOffset(this.value.dataType())).and(this::validateTypeOption);
    }

    private Expression.TypeResolution validateValue() {
        return TypeResolutions.isNotNull(this.value, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isType(this.value, dt -> dt.isNumeric() || dt.isDate() || DataType.isSpatialPoint(dt), this.sourceText(), TypeResolutions.ParamOrdinal.FIRST, "numeric, date or spatial point"));
    }

    private Expression.TypeResolution validateOriginScaleAndOffset(DataType valueType) {
        if (DataType.isSpatialPoint(valueType)) {
            boolean isGeoPoint = DataType.isGeoPoint(valueType);
            return this.validateOriginScaleAndOffset(DataType::isSpatialPoint, "spatial point", isGeoPoint ? DataType::isString : DataType::isNumeric, isGeoPoint ? "keyword or text" : "numeric", isGeoPoint ? DataType::isString : DataType::isNumeric, isGeoPoint ? "keyword or text" : "numeric");
        }
        if (DataType.isMillisOrNanos(valueType)) {
            return this.validateOriginScaleAndOffset(DataType::isMillisOrNanos, "datetime or date_nanos", DataType::isTimeDuration, "time_duration", DataType::isTimeDuration, "time_duration");
        }
        return this.validateOriginScaleAndOffset(DataType::isNumeric, "numeric", DataType::isNumeric, "numeric", DataType::isNumeric, "numeric");
    }

    private Expression.TypeResolution validateOriginScaleAndOffset(Predicate<DataType> originPredicate, String originDesc, Predicate<DataType> scalePredicate, String scaleDesc, Predicate<DataType> offsetPredicate, String offsetDesc) {
        Expression offset;
        if (this.options != null && (offset = ((MapExpression)this.options).keyFoldedMap().get(OFFSET)) != null && offset.dataType() != DataType.NULL && !offsetPredicate.test(offset.dataType())) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"{} option has invalid type, expected [{}], found [{}]", (Object[])new Object[]{OFFSET, offsetDesc, offset.dataType().typeName()}));
        }
        return TypeResolutions.isNotNull(this.origin, this.sourceText(), TypeResolutions.ParamOrdinal.SECOND).and(TypeResolutions.isType(this.origin, originPredicate, this.sourceText(), TypeResolutions.ParamOrdinal.SECOND, originDesc)).and(TypeResolutions.isNotNull(this.scale, this.sourceText(), TypeResolutions.ParamOrdinal.THIRD)).and(TypeResolutions.isType(this.scale, scalePredicate, this.sourceText(), TypeResolutions.ParamOrdinal.THIRD, scaleDesc));
    }

    private Expression.TypeResolution validateTypeOption() {
        if (this.options == null) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        Expression decayType = ((MapExpression)this.options).keyFoldedMap().get(TYPE);
        if (decayType == null || decayType.dataType() == DataType.NULL) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        if (decayType.dataType() != DataType.KEYWORD) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"{} option has invalid type, expected [{}], found [{}]", (Object[])new Object[]{TYPE, DataType.KEYWORD.typeName(), decayType.dataType().typeName()}));
        }
        String decayTypeName = BytesRefs.toString((Object)decayType.fold(FoldContext.small())).toLowerCase(Locale.ROOT);
        if (!DecayFunction.BY_NAME.containsKey(decayTypeName)) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"{} option has invalid value, expected one of [gauss, linear, exp], found [{}]", (Object[])new Object[]{TYPE, decayType.source().text()}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new Decay(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), this.options != null ? newChildren.get(3) : null);
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Decay::new, (Expression)this.children().get(0), (Expression)this.children().get(1), (Expression)this.children().get(2), (Expression)this.children().get(3));
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        DataType valueDataType = this.value.dataType();
        Options.populateMapWithExpressionsMultipleDataTypesAllowed((MapExpression)this.options, this.resolvedOptions, this.source(), TypeResolutions.ParamOrdinal.FOURTH, ALLOWED_OPTIONS);
        EvalOperator.ExpressionEvaluator.Factory valueFactory = toEvaluator.apply(this.value);
        Expression offsetExpr = (Expression)this.resolvedOptions.get(OFFSET);
        Expression decayExpr = (Expression)this.resolvedOptions.get(DECAY);
        Expression typeExpr = (Expression)this.resolvedOptions.get(TYPE);
        FoldContext foldCtx = toEvaluator.foldCtx();
        Object originFolded = this.origin.fold(foldCtx);
        Object scaleFolded = this.getFoldedScale(foldCtx, valueDataType);
        Object offsetFolded = this.getOffset(foldCtx, valueDataType, offsetExpr);
        Double decayFolded = decayExpr != null ? (Double)decayExpr.fold(foldCtx) : DEFAULT_DECAY;
        DecayFunction decayFunction = DecayFunction.fromBytesRef(typeExpr != null ? (BytesRef)typeExpr.fold(foldCtx) : DEFAULT_FUNCTION);
        return switch (valueDataType) {
            case DataType.INTEGER -> new DecayIntEvaluator.Factory(this.source(), valueFactory, (Integer)originFolded, (Integer)scaleFolded, (Integer)offsetFolded, decayFolded, decayFunction);
            case DataType.DOUBLE -> new DecayDoubleEvaluator.Factory(this.source(), valueFactory, (Double)originFolded, (Double)scaleFolded, (Double)offsetFolded, decayFolded, decayFunction);
            case DataType.LONG -> new DecayLongEvaluator.Factory(this.source(), valueFactory, (Long)originFolded, (Long)scaleFolded, (Long)offsetFolded, decayFolded, decayFunction);
            case DataType.GEO_POINT -> new DecayGeoPointEvaluator.Factory(this.source(), valueFactory, (BytesRef)originFolded, (BytesRef)scaleFolded, (BytesRef)offsetFolded, decayFolded, decayFunction);
            case DataType.CARTESIAN_POINT -> new DecayCartesianPointEvaluator.Factory(this.source(), valueFactory, (BytesRef)originFolded, (Double)scaleFolded, (Double)offsetFolded, decayFolded, decayFunction);
            case DataType.DATETIME -> new DecayDatetimeEvaluator.Factory(this.source(), valueFactory, (Long)originFolded, (Long)scaleFolded, (Long)offsetFolded, decayFolded, decayFunction);
            case DataType.DATE_NANOS -> new DecayDateNanosEvaluator.Factory(this.source(), valueFactory, (Long)originFolded, (Long)scaleFolded, (Long)offsetFolded, decayFolded, decayFunction);
            default -> throw new UnsupportedOperationException("Unsupported data typeExpr: " + String.valueOf((Object)valueDataType));
        };
    }

    @Override
    public void postOptimizationVerification(Failures failures) {
        Map.of(ORIGIN, this.origin, SCALE, this.scale).forEach((exprName, expr) -> {
            if (!(expr instanceof Literal)) {
                failures.add(Failure.fail(expr, "Function [{}] has non-literal value [{}].", this.sourceText(), exprName));
            }
        });
    }

    static double process(int value, int origin, int scale, int offset, double decay, DecayFunction decayFunction) {
        return decayFunction.numericDecay(value, origin, scale, offset, decay);
    }

    static double process(double value, double origin, double scale, double offset, double decay, DecayFunction decayFunction) {
        return decayFunction.numericDecay(value, origin, scale, offset, decay);
    }

    static double process(long value, long origin, long scale, long offset, double decay, DecayFunction decayFunction) {
        return decayFunction.numericDecay(value, origin, scale, offset, decay);
    }

    static double process(BytesRef value, BytesRef origin, BytesRef scale, BytesRef offset, double decay, DecayFunction decayFunction) {
        Point valuePoint = SpatialCoordinateTypes.UNSPECIFIED.wkbAsPoint(value);
        GeoPoint valueGeoPoint = new GeoPoint(valuePoint.getY(), valuePoint.getX());
        Point originPoint = SpatialCoordinateTypes.UNSPECIFIED.wkbAsPoint(origin);
        GeoPoint originGeoPoint = new GeoPoint(originPoint.getY(), originPoint.getX());
        String originStr = originGeoPoint.getX() + "," + originGeoPoint.getY();
        String scaleStr = scale.utf8ToString();
        String offsetStr = offset.utf8ToString();
        return decayFunction.geoPointDecay(valueGeoPoint, originStr, scaleStr, offsetStr, decay);
    }

    static double processCartesianPoint(BytesRef value, BytesRef origin, double scale, double offset, double decay, DecayFunction decayFunction) {
        Point valuePoint = SpatialCoordinateTypes.UNSPECIFIED.wkbAsPoint(value);
        Point originPoint = SpatialCoordinateTypes.UNSPECIFIED.wkbAsPoint(origin);
        double dx = valuePoint.getX() - originPoint.getX();
        double dy = valuePoint.getY() - originPoint.getY();
        double distance = Math.sqrt(dx * dx + dy * dy);
        distance = Math.max(0.0, distance - offset);
        return decayFunction.cartesianDecay(distance, scale, offset, decay);
    }

    static double processDatetime(long value, long origin, long scale, long offset, double decay, DecayFunction decayFunction) {
        return decayFunction.temporalDecay(value, origin, scale, offset, decay);
    }

    static double processDateNanos(long value, long origin, long scale, long offset, double decay, DecayFunction decayFunction) {
        return decayFunction.temporalDecay(value, origin, scale, offset, decay);
    }

    private static double decayDateLinear(long origin, long scale, long offset, double decay, long value) {
        double scaling = (double)scale / (1.0 - decay);
        long diff = value >= origin ? value - origin : origin - value;
        long distance = Math.max(0L, diff - offset);
        return Math.max(0.0, (scaling - (double)distance) / scaling);
    }

    private static double decayDateExp(long origin, long scale, long offset, double decay, long value) {
        double scaling = Math.log(decay) / (double)scale;
        long diff = value >= origin ? value - origin : origin - value;
        long distance = Math.max(0L, diff - offset);
        return Math.exp(scaling * (double)distance);
    }

    private static double decayDateGauss(long origin, long scale, long offset, double decay, long value) {
        double scaling = 0.5 * Math.pow(scale, 2.0) / Math.log(decay);
        long diff = value >= origin ? value - origin : origin - value;
        long distance = Math.max(0L, diff - offset);
        return Math.exp(0.5 * Math.pow(distance, 2.0) / scaling);
    }

    private Object getOffset(FoldContext foldCtx, DataType valueDataType, Expression offset) {
        if (offset == null) {
            return this.getDefaultOffset(valueDataType);
        }
        if (!DataType.isTimeDuration(offset.dataType())) {
            return offset.fold(foldCtx);
        }
        if (DataType.isDateNanos(valueDataType)) {
            return this.getTemporalOffsetAsNanos(foldCtx, offset);
        }
        return this.getTemporalOffsetAsMillis(foldCtx, offset);
    }

    private Object getFoldedScale(FoldContext foldCtx, DataType valueDataType) {
        Object foldedScale = this.scale.fold(foldCtx);
        if (!DataType.isTimeDuration(this.scale.dataType())) {
            return foldedScale;
        }
        if (DataType.isDateNanos(valueDataType)) {
            return ((Duration)foldedScale).toNanos();
        }
        return ((Duration)foldedScale).toMillis();
    }

    private Long getTemporalOffsetAsMillis(FoldContext foldCtx, Expression offset) {
        Object foldedOffset = offset.fold(foldCtx);
        return ((Duration)foldedOffset).toMillis();
    }

    private Long getTemporalOffsetAsNanos(FoldContext foldCtx, Expression offset) {
        Object foldedOffset = offset.fold(foldCtx);
        Duration offsetDuration = (Duration)foldedOffset;
        return offsetDuration.toNanos();
    }

    private Object getDefaultOffset(DataType valueDataType) {
        return switch (valueDataType) {
            case DataType.INTEGER -> DEFAULT_INTEGER_OFFSET;
            case DataType.LONG -> DEFAULT_LONG_OFFSET;
            case DataType.DOUBLE -> DEFAULT_DOUBLE_OFFSET;
            case DataType.GEO_POINT -> DEFAULT_GEO_POINT_OFFSET;
            case DataType.CARTESIAN_POINT -> DEFAULT_CARTESIAN_POINT_OFFSET;
            case DataType.DATETIME, DataType.DATE_NANOS -> DEFAULT_TEMPORAL_OFFSET;
            default -> throw new UnsupportedOperationException("Unsupported data type: " + String.valueOf((Object)valueDataType));
        };
    }

    public static enum DecayFunction {
        LINEAR("linear"){

            @Override
            public double numericDecay(double value, double origin, double scale, double offset, double decay) {
                return new ScoreScriptUtils.DecayNumericLinear(origin, scale, offset, decay).decayNumericLinear(value);
            }

            @Override
            public double geoPointDecay(GeoPoint value, String origin, String scale, String offset, double decay) {
                return new ScoreScriptUtils.DecayGeoLinear(origin, scale, offset, decay).decayGeoLinear(value);
            }

            @Override
            public double cartesianDecay(double distance, double scale, double offset, double decay) {
                double scaling = scale / (1.0 - decay);
                return Math.max(0.0, (scaling - distance) / scaling);
            }

            @Override
            public double temporalDecay(long value, long origin, long scale, long offset, double decay) {
                return Decay.decayDateLinear(origin, scale, offset, decay, value);
            }
        }
        ,
        EXPONENTIAL("exp"){

            @Override
            public double numericDecay(double value, double origin, double scale, double offset, double decay) {
                return new ScoreScriptUtils.DecayNumericExp(origin, scale, offset, decay).decayNumericExp(value);
            }

            @Override
            public double geoPointDecay(GeoPoint value, String origin, String scale, String offset, double decay) {
                return new ScoreScriptUtils.DecayGeoExp(origin, scale, offset, decay).decayGeoExp(value);
            }

            @Override
            public double cartesianDecay(double distance, double scale, double offset, double decay) {
                double scaling = Math.log(decay) / scale;
                return Math.exp(scaling * distance);
            }

            @Override
            public double temporalDecay(long value, long origin, long scale, long offset, double decay) {
                return Decay.decayDateExp(origin, scale, offset, decay, value);
            }
        }
        ,
        GAUSSIAN("gauss"){

            @Override
            public double numericDecay(double value, double origin, double scale, double offset, double decay) {
                return new ScoreScriptUtils.DecayNumericGauss(origin, scale, offset, decay).decayNumericGauss(value);
            }

            @Override
            public double geoPointDecay(GeoPoint value, String origin, String scale, String offset, double decay) {
                return new ScoreScriptUtils.DecayGeoGauss(origin, scale, offset, decay).decayGeoGauss(value);
            }

            @Override
            public double cartesianDecay(double distance, double scale, double offset, double decay) {
                double sigmaSquared = -Math.pow(scale, 2.0) / (2.0 * Math.log(decay));
                return Math.exp(-Math.pow(distance, 2.0) / (2.0 * sigmaSquared));
            }

            @Override
            public double temporalDecay(long value, long origin, long scale, long offset, double decay) {
                return Decay.decayDateGauss(origin, scale, offset, decay, value);
            }
        };

        private final String functionName;
        private static final Map<String, DecayFunction> BY_NAME;

        private DecayFunction(String functionName) {
            this.functionName = functionName;
        }

        public abstract double numericDecay(double var1, double var3, double var5, double var7, double var9);

        public abstract double geoPointDecay(GeoPoint var1, String var2, String var3, String var4, double var5);

        public abstract double cartesianDecay(double var1, double var3, double var5, double var7);

        public abstract double temporalDecay(long var1, long var3, long var5, long var7, double var9);

        public static DecayFunction fromBytesRef(BytesRef functionType) {
            return BY_NAME.getOrDefault(functionType.utf8ToString(), LINEAR);
        }

        static {
            BY_NAME = Arrays.stream(DecayFunction.values()).collect(Collectors.toMap(df -> df.functionName, df -> df));
        }
    }
}

