/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.nulls;

import java.util.List;
import java.util.stream.IntStream;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.ExponentialHistogramBlock;
import org.elasticsearch.compute.data.ExponentialHistogramBlockBuilder;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;

abstract sealed class CoalesceExponentialHistogramEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(CoalesceExponentialHistogramEvaluator.class);
    protected final DriverContext driverContext;
    protected final List<EvalOperator.ExpressionEvaluator> evaluators;

    static EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator, List<Expression> children) {
        final List<EvalOperator.ExpressionEvaluator.Factory> childEvaluators = children.stream().map(toEvaluator::apply).toList();
        if (childEvaluators.stream().allMatch(EvalOperator.ExpressionEvaluator.Factory::eagerEvalSafeInLazy)) {
            return new EvalOperator.ExpressionEvaluator.Factory(){

                public EvalOperator.ExpressionEvaluator get(DriverContext context) {
                    return new CoalesceExponentialHistogramEagerEvaluator(context, childEvaluators.stream().map(x -> x.get(context)).toList());
                }

                public String toString() {
                    return "CoalesceExponentialHistogramEagerEvaluator[values=" + String.valueOf(childEvaluators) + "]";
                }
            };
        }
        return new EvalOperator.ExpressionEvaluator.Factory(){

            public EvalOperator.ExpressionEvaluator get(DriverContext context) {
                return new CoalesceExponentialHistogramLazyEvaluator(context, childEvaluators.stream().map(x -> x.get(context)).toList());
            }

            public String toString() {
                return "CoalesceExponentialHistogramLazyEvaluator[values=" + String.valueOf(childEvaluators) + "]";
            }
        };
    }

    protected CoalesceExponentialHistogramEvaluator(DriverContext driverContext, List<EvalOperator.ExpressionEvaluator> evaluators) {
        this.driverContext = driverContext;
        this.evaluators = evaluators;
    }

    public final ExponentialHistogramBlock eval(Page page) {
        return this.entireBlock(page);
    }

    private ExponentialHistogramBlock entireBlock(Page page) {
        ExponentialHistogramBlock lastFullBlock;
        int lastFullBlockIdx = 0;
        while (true) {
            lastFullBlock = (ExponentialHistogramBlock)this.evaluators.get(lastFullBlockIdx++).eval(page);
            if (lastFullBlockIdx == this.evaluators.size() || lastFullBlock.asVector() != null) {
                return lastFullBlock;
            }
            if (!lastFullBlock.areAllValuesNull()) break;
            lastFullBlock.close();
        }
        return this.perPosition(page, lastFullBlock, lastFullBlockIdx);
    }

    protected abstract ExponentialHistogramBlock perPosition(Page var1, ExponentialHistogramBlock var2, int var3);

    public final String toString() {
        return this.getClass().getSimpleName() + "[values=" + String.valueOf(this.evaluators) + "]";
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        for (EvalOperator.ExpressionEvaluator e : this.evaluators) {
            baseRamBytesUsed += e.baseRamBytesUsed();
        }
        return baseRamBytesUsed;
    }

    public final void close() {
        Releasables.closeExpectNoException(() -> Releasables.close(this.evaluators));
    }

    static final class CoalesceExponentialHistogramLazyEvaluator
    extends CoalesceExponentialHistogramEvaluator {
        CoalesceExponentialHistogramLazyEvaluator(DriverContext driverContext, List<EvalOperator.ExpressionEvaluator> evaluators) {
            super(driverContext, evaluators);
        }

        @Override
        protected ExponentialHistogramBlock perPosition(Page page, ExponentialHistogramBlock lastFullBlock, int firstToEvaluate) {
            int positionCount = page.getPositionCount();
            try {
                ExponentialHistogramBlock exponentialHistogramBlock;
                block25: {
                    ExponentialHistogramBlockBuilder result = this.driverContext.blockFactory().newExponentialHistogramBlockBuilder(positionCount);
                    try {
                        block19: for (int p = 0; p < positionCount; ++p) {
                            if (!lastFullBlock.isNull(p)) {
                                result.copyFrom((Block)lastFullBlock, p, p + 1);
                                continue;
                            }
                            int[] positions = new int[]{p};
                            Page limited = new Page(1, (Block[])IntStream.range(0, page.getBlockCount()).mapToObj(b -> page.getBlock(b).filter(positions)).toArray(Block[]::new));
                            try (Releasable ignored = () -> ((Page)limited).releaseBlocks();){
                                for (int e = firstToEvaluate; e < this.evaluators.size(); ++e) {
                                    try (ExponentialHistogramBlock block = (ExponentialHistogramBlock)((EvalOperator.ExpressionEvaluator)this.evaluators.get(e)).eval(limited);){
                                        if (block.isNull(0)) continue;
                                        result.copyFrom(block, 0);
                                        continue block19;
                                    }
                                }
                                result.appendNull();
                                continue;
                            }
                        }
                        exponentialHistogramBlock = result.build();
                        if (result == null) break block25;
                    }
                    catch (Throwable throwable) {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    result.close();
                }
                return exponentialHistogramBlock;
            }
            finally {
                lastFullBlock.close();
            }
        }
    }

    static final class CoalesceExponentialHistogramEagerEvaluator
    extends CoalesceExponentialHistogramEvaluator {
        CoalesceExponentialHistogramEagerEvaluator(DriverContext driverContext, List<EvalOperator.ExpressionEvaluator> evaluators) {
            super(driverContext, evaluators);
        }

        @Override
        protected ExponentialHistogramBlock perPosition(Page page, ExponentialHistogramBlock lastFullBlock, int firstToEvaluate) {
            int positionCount = page.getPositionCount();
            ExponentialHistogramBlock[] flatten = new ExponentialHistogramBlock[this.evaluators.size() - firstToEvaluate + 1];
            try {
                ExponentialHistogramBlock exponentialHistogramBlock;
                block12: {
                    flatten[0] = lastFullBlock;
                    for (int f = 1; f < flatten.length; ++f) {
                        flatten[f] = (ExponentialHistogramBlock)((EvalOperator.ExpressionEvaluator)this.evaluators.get(firstToEvaluate + f - 1)).eval(page);
                    }
                    ExponentialHistogramBlockBuilder result = this.driverContext.blockFactory().newExponentialHistogramBlockBuilder(positionCount);
                    try {
                        block9: for (int p = 0; p < positionCount; ++p) {
                            for (ExponentialHistogramBlock f : flatten) {
                                if (f.isNull(p)) continue;
                                result.copyFrom(f, p);
                                continue block9;
                            }
                            result.appendNull();
                        }
                        exponentialHistogramBlock = result.build();
                        if (result == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    result.close();
                }
                return exponentialHistogramBlock;
            }
            finally {
                Releasables.close((Releasable[])flatten);
            }
        }
    }
}

