/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvIntersection;

public final class MvIntersectionLongEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MvIntersectionLongEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator field1;
    private final EvalOperator.ExpressionEvaluator field2;
    private final DriverContext driverContext;
    private Warnings warnings;

    public MvIntersectionLongEvaluator(Source source, EvalOperator.ExpressionEvaluator field1, EvalOperator.ExpressionEvaluator field2, DriverContext driverContext) {
        this.source = source;
        this.field1 = field1;
        this.field2 = field2;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock field1Block = (LongBlock)this.field1.eval(page);){
            LongBlock longBlock;
            block12: {
                LongBlock field2Block = (LongBlock)this.field2.eval(page);
                try {
                    longBlock = this.eval(page.getPositionCount(), field1Block, field2Block);
                    if (field2Block == null) break block12;
                }
                catch (Throwable throwable) {
                    if (field2Block != null) {
                        try {
                            field2Block.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                field2Block.close();
            }
            return longBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.field1.baseRamBytesUsed();
        return baseRamBytesUsed += this.field2.baseRamBytesUsed();
    }

    public LongBlock eval(int positionCount, LongBlock field1Block, LongBlock field2Block) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!field1Block.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (!field2Block.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                MvIntersection.process(result, p, field1Block, field2Block);
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public String toString() {
        return "MvIntersectionLongEvaluator[field1=" + String.valueOf(this.field1) + ", field2=" + String.valueOf(this.field2) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.field1, this.field2});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field1;
        private final EvalOperator.ExpressionEvaluator.Factory field2;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field1, EvalOperator.ExpressionEvaluator.Factory field2) {
            this.source = source;
            this.field1 = field1;
            this.field2 = field2;
        }

        public MvIntersectionLongEvaluator get(DriverContext context) {
            return new MvIntersectionLongEvaluator(this.source, this.field1.get(context), this.field2.get(context), context);
        }

        public String toString() {
            return "MvIntersectionLongEvaluator[field1=" + String.valueOf(this.field1) + ", field2=" + String.valueOf(this.field2) + "]";
        }
    }
}

