/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvIntersection;

public final class MvIntersectionIntEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MvIntersectionIntEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator field1;
    private final EvalOperator.ExpressionEvaluator field2;
    private final DriverContext driverContext;
    private Warnings warnings;

    public MvIntersectionIntEvaluator(Source source, EvalOperator.ExpressionEvaluator field1, EvalOperator.ExpressionEvaluator field2, DriverContext driverContext) {
        this.source = source;
        this.field1 = field1;
        this.field2 = field2;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (IntBlock field1Block = (IntBlock)this.field1.eval(page);){
            IntBlock intBlock;
            block12: {
                IntBlock field2Block = (IntBlock)this.field2.eval(page);
                try {
                    intBlock = this.eval(page.getPositionCount(), field1Block, field2Block);
                    if (field2Block == null) break block12;
                }
                catch (Throwable throwable) {
                    if (field2Block != null) {
                        try {
                            field2Block.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                field2Block.close();
            }
            return intBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.field1.baseRamBytesUsed();
        return baseRamBytesUsed += this.field2.baseRamBytesUsed();
    }

    public IntBlock eval(int positionCount, IntBlock field1Block, IntBlock field2Block) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!field1Block.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (!field2Block.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                MvIntersection.process(result, p, field1Block, field2Block);
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public String toString() {
        return "MvIntersectionIntEvaluator[field1=" + String.valueOf(this.field1) + ", field2=" + String.valueOf(this.field2) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.field1, this.field2});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field1;
        private final EvalOperator.ExpressionEvaluator.Factory field2;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field1, EvalOperator.ExpressionEvaluator.Factory field2) {
            this.source = source;
            this.field1 = field1;
            this.field2 = field2;
        }

        public MvIntersectionIntEvaluator get(DriverContext context) {
            return new MvIntersectionIntEvaluator(this.source, this.field1.get(context), this.field2.get(context), context);
        }

        public String toString() {
            return "MvIntersectionIntEvaluator[field1=" + String.valueOf(this.field1) + ", field2=" + String.valueOf(this.field2) + "]";
        }
    }
}

