/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvIntersectionBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvIntersectionBytesRefEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvIntersectionDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvIntersectionIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvIntersectionLongEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class MvIntersection
extends BinaryScalarFunction
implements EvaluatorMapper {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MvIntersection", MvIntersection::new);
    private DataType dataType;

    @FunctionInfo(returnType={"boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "unsigned_long", "version"}, description="Returns the values that appear in both input fields. Returns `null` if either field is null or if no values match.", preview=true, examples={@Example(file="mv_intersection", tag="testMvIntersectionWithIntValues"), @Example(file="mv_intersection", tag="testMvIntersectionWithLongValues"), @Example(file="mv_intersection", tag="testMvIntersectionWithBooleanValues"), @Example(file="mv_intersection", tag="testMvIntersectionWithDoubleValues"), @Example(file="mv_intersection", tag="testMvIntersectionWithBytesRefValues")}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.3.0")})
    public MvIntersection(Source source, @Param(name="field1", type={"boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="Multivalue expression. If null, the function returns null.") Expression field1, @Param(name="field2", type={"boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="Multivalue expression. If null, the function returns null.") Expression field2) {
        super(source, field1, field2);
    }

    private MvIntersection(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    @Override
    public Object fold(FoldContext ctx) {
        return EvaluatorMapper.super.fold(this.source(), ctx);
    }

    static void process(BooleanBlock.Builder builder, int position, BooleanBlock field1, BooleanBlock field2) {
        MvIntersection.processIntersectionSet((Block.Builder)builder, position, (Block)field1, (Block)field2, (p, block) -> ((BooleanBlock)block).getBoolean(p.intValue()), arg_0 -> ((BooleanBlock.Builder)builder).appendBoolean(arg_0));
    }

    static void process(BytesRefBlock.Builder builder, int position, BytesRefBlock field1, BytesRefBlock field2) {
        MvIntersection.processIntersectionSet((Block.Builder)builder, position, (Block)field1, (Block)field2, (p, block) -> {
            BytesRef value = new BytesRef();
            return ((BytesRefBlock)block).getBytesRef(p.intValue(), value);
        }, arg_0 -> ((BytesRefBlock.Builder)builder).appendBytesRef(arg_0));
    }

    static void process(IntBlock.Builder builder, int position, IntBlock field1, IntBlock field2) {
        MvIntersection.processIntersectionSet((Block.Builder)builder, position, (Block)field1, (Block)field2, (p, block) -> ((IntBlock)block).getInt(p.intValue()), arg_0 -> ((IntBlock.Builder)builder).appendInt(arg_0));
    }

    static void process(LongBlock.Builder builder, int position, LongBlock field1, LongBlock field2) {
        MvIntersection.processIntersectionSet((Block.Builder)builder, position, (Block)field1, (Block)field2, (p, block) -> ((LongBlock)block).getLong(p.intValue()), arg_0 -> ((LongBlock.Builder)builder).appendLong(arg_0));
    }

    static void process(DoubleBlock.Builder builder, int position, DoubleBlock field1, DoubleBlock field2) {
        MvIntersection.processIntersectionSet((Block.Builder)builder, position, (Block)field1, (Block)field2, (p, block) -> ((DoubleBlock)block).getDouble(p.intValue()), arg_0 -> ((DoubleBlock.Builder)builder).appendDouble(arg_0));
    }

    @Override
    public DataType dataType() {
        if (this.dataType == null) {
            this.resolveType();
        }
        return this.dataType;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        if (this.left().dataType() != DataType.NULL && this.right().dataType() != DataType.NULL) {
            this.dataType = this.left().dataType().noText();
            return TypeResolutions.isType(this.right(), t -> t.noText() == this.left().dataType().noText(), this.sourceText(), TypeResolutions.ParamOrdinal.SECOND, this.left().dataType().noText().typeName());
        }
        Expression evaluatedField = this.left().dataType() == DataType.NULL ? this.right() : this.left();
        this.dataType = evaluatedField.dataType().noText();
        Expression.TypeResolution resolution = TypeResolutions.isRepresentableExceptCountersDenseVectorAggregateMetricDoubleAndHistogram(evaluatedField, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return resolution;
    }

    @Override
    protected BinaryScalarFunction replaceChildren(Expression newLeft, Expression newRight) {
        return new MvIntersection(this.source(), newLeft, newRight);
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, MvIntersection::new, this.left(), this.right());
    }

    public String getWriteableName() {
        return MvIntersection.ENTRY.name;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return switch (PlannerUtils.toElementType(this.dataType())) {
            case ElementType.BOOLEAN -> new MvIntersectionBooleanEvaluator.Factory(this.source(), toEvaluator.apply(this.left()), toEvaluator.apply(this.right()));
            case ElementType.BYTES_REF -> new MvIntersectionBytesRefEvaluator.Factory(this.source(), toEvaluator.apply(this.left()), toEvaluator.apply(this.right()));
            case ElementType.INT -> new MvIntersectionIntEvaluator.Factory(this.source(), toEvaluator.apply(this.left()), toEvaluator.apply(this.right()));
            case ElementType.LONG -> new MvIntersectionLongEvaluator.Factory(this.source(), toEvaluator.apply(this.left()), toEvaluator.apply(this.right()));
            case ElementType.DOUBLE -> new MvIntersectionDoubleEvaluator.Factory(this.source(), toEvaluator.apply(this.left()), toEvaluator.apply(this.right()));
            case ElementType.NULL -> EvalOperator.CONSTANT_NULL_FACTORY;
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.dataType);
        };
    }

    @Override
    public Nullability nullable() {
        return Nullability.TRUE;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left(), this.right());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MvIntersection other = (MvIntersection)obj;
        return Objects.equals(other.left(), this.left()) && Objects.equals(other.right(), this.right());
    }

    static <T> void processIntersectionSet(Block.Builder builder, int position, Block field1, Block field2, BiFunction<Integer, Block, T> getValueFunction, Consumer<T> addValueFunction) {
        int firstValueCount = field1.getValueCount(position);
        int secondValueCount = field2.getValueCount(position);
        if (firstValueCount == 0 || secondValueCount == 0) {
            builder.appendNull();
            return;
        }
        int firstValueIndex = field1.getFirstValueIndex(position);
        int secondValueIndex = field2.getFirstValueIndex(position);
        LinkedHashSet<T> values = new LinkedHashSet<T>();
        for (int i = 0; i < firstValueCount; ++i) {
            values.add(getValueFunction.apply(firstValueIndex + i, field1));
        }
        HashSet<T> secondValues = new HashSet<T>();
        for (int i = 0; i < secondValueCount; ++i) {
            secondValues.add(getValueFunction.apply(secondValueIndex + i, field2));
        }
        values.retainAll(secondValues);
        if (values.isEmpty()) {
            builder.appendNull();
            return;
        }
        builder.beginPositionEntry();
        for (Object value : values) {
            addValueFunction.accept(value);
        }
        builder.endPositionEntry();
    }
}

