/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvContains;

public final class MvContainsBooleanEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MvContainsBooleanEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator superset;
    private final EvalOperator.ExpressionEvaluator subset;
    private final DriverContext driverContext;
    private Warnings warnings;

    public MvContainsBooleanEvaluator(Source source, EvalOperator.ExpressionEvaluator superset, EvalOperator.ExpressionEvaluator subset, DriverContext driverContext) {
        this.source = source;
        this.superset = superset;
        this.subset = subset;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BooleanBlock supersetBlock = (BooleanBlock)this.superset.eval(page);){
            BooleanBlock booleanBlock;
            block12: {
                BooleanBlock subsetBlock = (BooleanBlock)this.subset.eval(page);
                try {
                    booleanBlock = this.eval(page.getPositionCount(), supersetBlock, subsetBlock);
                    if (subsetBlock == null) break block12;
                }
                catch (Throwable throwable) {
                    if (subsetBlock != null) {
                        try {
                            subsetBlock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                subsetBlock.close();
            }
            return booleanBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.superset.baseRamBytesUsed();
        return baseRamBytesUsed += this.subset.baseRamBytesUsed();
    }

    public BooleanBlock eval(int positionCount, BooleanBlock supersetBlock, BooleanBlock subsetBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendBoolean(MvContains.process(p, supersetBlock, subsetBlock));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public String toString() {
        return "MvContainsBooleanEvaluator[superset=" + String.valueOf(this.superset) + ", subset=" + String.valueOf(this.subset) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.superset, this.subset});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory superset;
        private final EvalOperator.ExpressionEvaluator.Factory subset;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory superset, EvalOperator.ExpressionEvaluator.Factory subset) {
            this.source = source;
            this.superset = superset;
            this.subset = subset;
        }

        public MvContainsBooleanEvaluator get(DriverContext context) {
            return new MvContainsBooleanEvaluator(this.source, this.superset.get(context), this.subset.get(context), context);
        }

        public String toString() {
            return "MvContainsBooleanEvaluator[superset=" + String.valueOf(this.superset) + ", subset=" + String.valueOf(this.subset) + "]";
        }
    }
}

