/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.AbstractTrigonometricFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.TanEvaluator;

public class Tan
extends AbstractTrigonometricFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Tan", Tan::new);

    @FunctionInfo(returnType={"double"}, description="Returns the {wikipedia}/Sine_and_cosine[tangent] of an angle.", examples={@Example(file="floats", tag="tan")})
    public Tan(Source source, @Param(name="angle", type={"double", "integer", "long", "unsigned_long"}, description="An angle, in radians. If `null`, the function returns `null`.") Expression angle) {
        super(source, angle);
    }

    private Tan(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Tan.ENTRY.name;
    }

    @Override
    protected EvalOperator.ExpressionEvaluator.Factory doubleEvaluator(EvalOperator.ExpressionEvaluator.Factory field) {
        return new TanEvaluator.Factory(this.source(), field);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new Tan(this.source(), newChildren.get(0));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Tan::new, this.field());
    }

    static double process(double val) {
        return Math.tan(val);
    }
}

