/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.math.Maths;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundDoubleNoDecimalsEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class Round
extends EsqlScalarFunction
implements OptionalArgument {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Round", Round::new);
    private static final BiFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> EVALUATOR_IDENTITY = (s, e) -> e;
    private final Expression field;
    private final Expression decimals;

    @FunctionInfo(returnType={"double", "integer", "long", "unsigned_long"}, description="Rounds a number to the specified number of decimal places.\nDefaults to 0, which returns the nearest integer. If the\nprecision is a negative number, rounds to the number of digits left\nof the decimal point.", examples={@Example(file="docs", tag="round")})
    public Round(Source source, @Param(name="number", type={"double", "integer", "long", "unsigned_long"}, description="The numeric value to round. If `null`, the function returns `null`.") Expression field, @Param(optional=true, name="decimals", type={"integer", "long"}, description="The number of decimal places to round to. Defaults to 0. If `null`, the function returns `null`.") Expression decimals) {
        super(source, decimals != null ? Arrays.asList(field, decimals) : Arrays.asList(field));
        this.field = field;
        this.decimals = decimals;
    }

    private Round(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readOptionalNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
        out.writeOptionalNamedWriteable((NamedWriteable)this.decimals);
    }

    public String getWriteableName() {
        return Round.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isNumeric(this.field, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return this.decimals == null ? Expression.TypeResolution.TYPE_RESOLVED : TypeResolutions.isType(this.decimals, dt -> dt.isWholeNumber() && dt != DataType.UNSIGNED_LONG, this.sourceText(), TypeResolutions.ParamOrdinal.SECOND, "whole number except unsigned_long or counter types");
    }

    @Override
    public boolean foldable() {
        return this.field.foldable() && (this.decimals == null || this.decimals.foldable());
    }

    static double process(double val) {
        return Maths.round(val, 0L).doubleValue();
    }

    static int process(int val, long decimals) {
        return Maths.round(val, decimals).intValue();
    }

    static long process(long val, long decimals) {
        return Maths.round(val, decimals);
    }

    static long processUnsignedLong(long val, long decimals) {
        if (decimals <= -20L) {
            return EsqlDataTypeConverter.longToUnsignedLong(0L, false);
        }
        Number ul = NumericUtils.unsignedLongAsNumber((long)val);
        if (ul instanceof BigInteger) {
            BigInteger bi = (BigInteger)ul;
            BigInteger rounded = Maths.round(bi, decimals);
            return EsqlDataTypeConverter.bigIntegerToUnsignedLong(rounded);
        }
        return EsqlDataTypeConverter.longToUnsignedLong(Maths.round(ul.longValue(), decimals), false);
    }

    static double process(double val, long decimals) {
        return Maths.round(val, decimals).doubleValue();
    }

    @Override
    public final Expression replaceChildren(List<Expression> newChildren) {
        return new Round(this.source(), newChildren.get(0), this.decimals() == null ? null : newChildren.get(1));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Round::new, this.field(), this.decimals());
    }

    public Expression field() {
        return this.field;
    }

    public Expression decimals() {
        return this.decimals;
    }

    @Override
    public DataType dataType() {
        return this.field.dataType();
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        DataType fieldType = this.dataType();
        if (fieldType == DataType.DOUBLE) {
            return this.toEvaluator(toEvaluator, RoundDoubleNoDecimalsEvaluator.Factory::new, (TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)RoundDoubleEvaluator.Factory::new));
        }
        if (fieldType == DataType.INTEGER) {
            return this.toEvaluator(toEvaluator, EVALUATOR_IDENTITY, (TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)RoundIntEvaluator.Factory::new));
        }
        if (fieldType == DataType.LONG) {
            return this.toEvaluator(toEvaluator, EVALUATOR_IDENTITY, (TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)RoundLongEvaluator.Factory::new));
        }
        if (fieldType == DataType.UNSIGNED_LONG) {
            return this.toEvaluator(toEvaluator, EVALUATOR_IDENTITY, (TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)RoundUnsignedLongEvaluator.Factory::new));
        }
        throw EsqlIllegalArgumentException.illegalDataType(fieldType);
    }

    private EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator, BiFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> noDecimals, TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> withDecimals) {
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(this.field());
        if (this.decimals == null) {
            return noDecimals.apply(this.source(), fieldEvaluator);
        }
        EvalOperator.ExpressionEvaluator.Factory decimalsEvaluator = Cast.cast(this.source(), this.decimals().dataType(), DataType.LONG, toEvaluator.apply(this.decimals()));
        return (EvalOperator.ExpressionEvaluator.Factory)withDecimals.apply((Object)this.source(), (Object)fieldEvaluator, (Object)decimalsEvaluator);
    }
}

