/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Atan2Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Atan2
extends EsqlScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Atan2", Atan2::new);
    private final Expression y;
    private final Expression x;

    @FunctionInfo(returnType={"double"}, description="The {wikipedia}/Atan2[angle] between the positive x-axis and the ray from the\norigin to the point (x , y) in the Cartesian plane, expressed in radians.", examples={@Example(file="floats", tag="atan2")})
    public Atan2(Source source, @Param(name="y_coordinate", type={"double", "integer", "long", "unsigned_long"}, description="y coordinate. If `null`, the function returns `null`.") Expression y, @Param(name="x_coordinate", type={"double", "integer", "long", "unsigned_long"}, description="x coordinate. If `null`, the function returns `null`.") Expression x) {
        super(source, List.of(y, x));
        this.y = y;
        this.x = x;
    }

    private Atan2(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.y);
        out.writeNamedWriteable((NamedWriteable)this.x);
    }

    public String getWriteableName() {
        return Atan2.ENTRY.name;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new Atan2(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Atan2::new, this.y, this.x);
    }

    static double process(double y, double x) {
        return Math.atan2(y, x);
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isNumeric(this.y, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isNumeric(this.x, this.sourceText(), TypeResolutions.ParamOrdinal.SECOND);
    }

    @Override
    public boolean foldable() {
        return Expressions.foldable(this.children());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory yEval = Cast.cast(this.source(), this.y.dataType(), DataType.DOUBLE, toEvaluator.apply(this.y));
        EvalOperator.ExpressionEvaluator.Factory xEval = Cast.cast(this.source(), this.x.dataType(), DataType.DOUBLE, toEvaluator.apply(this.x));
        return new Atan2Evaluator.Factory(this.source(), yEval, xEval);
    }

    public Expression y() {
        return this.y;
    }

    public Expression x() {
        return this.x;
    }
}

