/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.histogram;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.HistogramBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class ExtractHistogramComponent
extends EsqlScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ExtractHistogramComponent", ExtractHistogramComponent::new);
    private final Expression field;
    private final Expression componentOrdinal;

    @FunctionInfo(returnType={"double"})
    public ExtractHistogramComponent(Source source, @Param(name="histogram", type={"exponential_histogram", "tdigest"}) Expression field, @Param(name="component", type={"integer"}) Expression componentOrdinal) {
        super(source, List.of(field, componentOrdinal));
        this.field = field;
        this.componentOrdinal = componentOrdinal;
    }

    private ExtractHistogramComponent(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public static Expression create(Source source, Expression field, HistogramBlock.Component component) {
        return new ExtractHistogramComponent(source, field, new Literal(source, component.ordinal(), DataType.INTEGER));
    }

    public Expression field() {
        return this.field;
    }

    Expression componentOrdinal() {
        return this.componentOrdinal;
    }

    private HistogramBlock.Component component() {
        if (!this.componentOrdinal.foldable()) {
            throw new EsqlIllegalArgumentException("Received a non-foldable value for component ordinal");
        }
        Number ordinal = (Number)this.componentOrdinal.fold(FoldContext.small());
        if (ordinal == null) {
            return null;
        }
        return HistogramBlock.Component.values()[ordinal.intValue()];
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
        out.writeNamedWriteable((NamedWriteable)this.componentOrdinal);
    }

    public String getWriteableName() {
        return ExtractHistogramComponent.ENTRY.name;
    }

    @Override
    public DataType dataType() {
        HistogramBlock.Component component = this.component();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"MIN", "MAX", "SUM", "COUNT"}, (HistogramBlock.Component)component, n)) {
            default -> throw new MatchException(null, null);
            case -1 -> DataType.NULL;
            case 0, 1, 2, 3 -> DataType.DOUBLE;
        };
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new ExtractHistogramComponent(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, ExtractHistogramComponent::new, this.field, this.componentOrdinal);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution histoTypeCheck = TypeResolutions.isType(this.field, dt -> dt == DataType.EXPONENTIAL_HISTOGRAM || dt == DataType.TDIGEST, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST, "exponential_histogram", "tdigest");
        Expression.TypeResolution componentOrdinalCheck = TypeResolutions.isType(this.componentOrdinal, dt -> dt == DataType.INTEGER, this.sourceText(), TypeResolutions.ParamOrdinal.SECOND, "integer").and(TypeResolutions.isFoldable(this.componentOrdinal, this.sourceText(), TypeResolutions.ParamOrdinal.SECOND));
        return histoTypeCheck.and(componentOrdinalCheck);
    }

    @Override
    public boolean foldable() {
        return Expressions.foldable(this.children());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        final EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(this.field);
        return new EvalOperator.ExpressionEvaluator.Factory(){

            public String toString() {
                return "ExtractHistogramComponentEvaluator[field=" + String.valueOf(fieldEvaluator) + ",component=" + String.valueOf(ExtractHistogramComponent.this.component()) + "]";
            }

            public EvalOperator.ExpressionEvaluator get(DriverContext context) {
                return new Evaluator(fieldEvaluator.get(context), ExtractHistogramComponent.this.component());
            }
        };
    }

    private record Evaluator(EvalOperator.ExpressionEvaluator fieldEvaluator, HistogramBlock.Component componentToExtract) implements EvalOperator.ExpressionEvaluator
    {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Evaluator.class);

        public Block eval(Page page) {
            try (Block block = this.fieldEvaluator.eval(page);){
                DoubleBlock doubleBlock = ((HistogramBlock)block).buildHistogramComponentBlock(this.componentToExtract);
                return doubleBlock;
            }
        }

        public long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED + this.fieldEvaluator.baseRamBytesUsed();
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable)this.fieldEvaluator);
        }

        @Override
        public String toString() {
            return "ExtractHistogramComponentEvaluator[field=" + String.valueOf(this.fieldEvaluator) + ",component=" + String.valueOf(this.componentToExtract) + "]";
        }
    }
}

