/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.util.Locale;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateFormat;

public final class DateFormatMillisEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DateFormatMillisEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator val;
    private final EvalOperator.ExpressionEvaluator formatter;
    private final Locale locale;
    private final DriverContext driverContext;
    private Warnings warnings;

    public DateFormatMillisEvaluator(Source source, EvalOperator.ExpressionEvaluator val, EvalOperator.ExpressionEvaluator formatter, Locale locale, DriverContext driverContext) {
        this.source = source;
        this.val = val;
        this.formatter = formatter;
        this.locale = locale;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock valBlock = (LongBlock)this.val.eval(page);){
            BytesRefBlock bytesRefBlock;
            block20: {
                BytesRefVector formatterVector;
                LongVector valVector;
                BytesRefBlock formatterBlock;
                block18: {
                    BytesRefBlock bytesRefBlock2;
                    block19: {
                        block16: {
                            BytesRefBlock bytesRefBlock3;
                            block17: {
                                formatterBlock = (BytesRefBlock)this.formatter.eval(page);
                                try {
                                    valVector = valBlock.asVector();
                                    if (valVector != null) break block16;
                                    bytesRefBlock3 = this.eval(page.getPositionCount(), valBlock, formatterBlock);
                                    if (formatterBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (formatterBlock != null) {
                                        try {
                                            formatterBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                formatterBlock.close();
                            }
                            return bytesRefBlock3;
                        }
                        formatterVector = formatterBlock.asVector();
                        if (formatterVector != null) break block18;
                        bytesRefBlock2 = this.eval(page.getPositionCount(), valBlock, formatterBlock);
                        if (formatterBlock == null) break block19;
                        formatterBlock.close();
                    }
                    return bytesRefBlock2;
                }
                bytesRefBlock = this.eval(page.getPositionCount(), valVector, formatterVector).asBlock();
                if (formatterBlock == null) break block20;
                formatterBlock.close();
            }
            return bytesRefBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.val.baseRamBytesUsed();
        return baseRamBytesUsed += this.formatter.baseRamBytesUsed();
    }

    public BytesRefBlock eval(int positionCount, LongBlock valBlock, BytesRefBlock formatterBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef formatterScratch = new BytesRef();
            block13: for (int p = 0; p < positionCount; ++p) {
                switch (valBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                switch (formatterBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                long val = valBlock.getLong(valBlock.getFirstValueIndex(p));
                BytesRef formatter = formatterBlock.getBytesRef(formatterBlock.getFirstValueIndex(p), formatterScratch);
                result.appendBytesRef(DateFormat.processMillis(val, formatter, this.locale));
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefVector eval(int positionCount, LongVector valVector, BytesRefVector formatterVector) {
        try (BytesRefVector.Builder result = this.driverContext.blockFactory().newBytesRefVectorBuilder(positionCount);){
            BytesRef formatterScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                long val = valVector.getLong(p);
                BytesRef formatter = formatterVector.getBytesRef(p, formatterScratch);
                result.appendBytesRef(DateFormat.processMillis(val, formatter, this.locale));
            }
            BytesRefVector bytesRefVector = result.build();
            return bytesRefVector;
        }
    }

    public String toString() {
        return "DateFormatMillisEvaluator[val=" + String.valueOf(this.val) + ", formatter=" + String.valueOf(this.formatter) + ", locale=" + String.valueOf(this.locale) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.val, this.formatter});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory val;
        private final EvalOperator.ExpressionEvaluator.Factory formatter;
        private final Locale locale;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory val, EvalOperator.ExpressionEvaluator.Factory formatter, Locale locale) {
            this.source = source;
            this.val = val;
            this.formatter = formatter;
            this.locale = locale;
        }

        public DateFormatMillisEvaluator get(DriverContext context) {
            return new DateFormatMillisEvaluator(this.source, this.val.get(context), this.formatter.get(context), this.locale, context);
        }

        public String toString() {
            return "DateFormatMillisEvaluator[val=" + String.valueOf(this.val) + ", formatter=" + String.valueOf(this.formatter) + ", locale=" + String.valueOf(this.locale) + "]";
        }
    }
}

