/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.TDigestBlock;
import org.elasticsearch.compute.data.TDigestBlockBuilder;
import org.elasticsearch.compute.data.TDigestHolder;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToTDigest;

public final class ToTDigestFromHistogramEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ToTDigestFromHistogramEvaluator.class);
    private final EvalOperator.ExpressionEvaluator in;

    public ToTDigestFromHistogramEvaluator(Source source, EvalOperator.ExpressionEvaluator in, DriverContext driverContext) {
        super(driverContext, source);
        this.in = in;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.in;
    }

    @Override
    public Block evalVector(Vector v) {
        BytesRefVector vector = (BytesRefVector)v;
        int positionCount = v.getPositionCount();
        BytesRef scratchPad = new BytesRef();
        if (vector.isConstant()) {
            try {
                return this.driverContext.blockFactory().newConstantTDigestBlockWith(this.evalValue(vector, 0, scratchPad), positionCount);
            }
            catch (IllegalArgumentException e) {
                this.registerException(e);
                return this.driverContext.blockFactory().newConstantNullBlock(positionCount);
            }
        }
        try (TDigestBlockBuilder builder = this.driverContext.blockFactory().newTDigestBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    builder.appendTDigest(this.evalValue(vector, p, scratchPad));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.registerException(e);
                    builder.appendNull();
                }
            }
            TDigestBlock tDigestBlock = builder.build();
            return tDigestBlock;
        }
    }

    private TDigestHolder evalValue(BytesRefVector container, int index, BytesRef scratchPad) {
        BytesRef value = container.getBytesRef(index, scratchPad);
        return ToTDigest.fromHistogram(value);
    }

    @Override
    public Block evalBlock(Block b) {
        BytesRefBlock block = (BytesRefBlock)b;
        int positionCount = block.getPositionCount();
        try (TDigestBlockBuilder builder = this.driverContext.blockFactory().newTDigestBlockBuilder(positionCount);){
            BytesRef scratchPad = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    try {
                        TDigestHolder value = this.evalValue(block, i, scratchPad);
                        if (!positionOpened && valueCount > 1) {
                            builder.beginPositionEntry();
                            positionOpened = true;
                        }
                        builder.appendTDigest(value);
                        valuesAppended = true;
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        this.registerException(e);
                    }
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            TDigestBlock tDigestBlock = builder.build();
            return tDigestBlock;
        }
    }

    private TDigestHolder evalValue(BytesRefBlock container, int index, BytesRef scratchPad) {
        BytesRef value = container.getBytesRef(index, scratchPad);
        return ToTDigest.fromHistogram(value);
    }

    public String toString() {
        return "ToTDigestFromHistogramEvaluator[in=" + String.valueOf(this.in) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.in);
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.in.baseRamBytesUsed();
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory in;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory in) {
            this.source = source;
            this.in = in;
        }

        public ToTDigestFromHistogramEvaluator get(DriverContext context) {
            return new ToTDigestFromHistogramEvaluator(this.source, this.in.get(context), context);
        }

        public String toString() {
            return "ToTDigestFromHistogramEvaluator[in=" + String.valueOf(this.in) + "]";
        }
    }
}

