/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.compute.data.TDigestHolder;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToTDigestFromHistogramEvaluator;

public class ToTDigest
extends AbstractConvertFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToTDigest", ToTDigest::new);
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.TDIGEST, (source, field) -> field), Map.entry(DataType.HISTOGRAM, ToTDigestFromHistogramEvaluator.Factory::new));

    @FunctionInfo(returnType={"tdigest"}, description="Converts an untyped histogram to a TDigest, assuming the values are centroids")
    public ToTDigest(Source source, @Param(name="field", type={"histogram"}, description="The histogram value to be converted") Expression field) {
        super(source, field);
    }

    protected ToTDigest(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public DataType dataType() {
        return DataType.TDIGEST;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToTDigest(this.source(), newChildren.get(0));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, ToTDigest::new, this.field());
    }

    public String getWriteableName() {
        return ToTDigest.ENTRY.name;
    }

    static TDigestHolder fromHistogram(BytesRef in) {
        if ((long)in.length > ByteSizeUnit.MB.toBytes(2L)) {
            throw new IllegalArgumentException("Histogram length is greater than 2MB");
        }
        ArrayList<Double> centroids = new ArrayList<Double>();
        ArrayList<Long> counts = new ArrayList<Long>();
        ByteArrayStreamInput streamInput = new ByteArrayStreamInput();
        streamInput.reset(in.bytes, in.offset, in.length);
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double sum = 0.0;
        long totalCount = 0L;
        try {
            while (streamInput.available() > 0) {
                long count = streamInput.readVLong();
                double value = Double.longBitsToDouble(streamInput.readLong());
                min = Math.min(min, value);
                max = Math.max(max, value);
                sum += value * (double)count;
                totalCount += count;
                centroids.add(value);
                counts.add(count);
            }
            if (totalCount == 0L) {
                min = Double.NaN;
                max = Double.NaN;
                sum = Double.NaN;
            }
            return new TDigestHolder(centroids, counts, min, max, sum, totalCount);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

