/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongBase;

public final class ToLongBaseEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ToLongBaseEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator string;
    private final EvalOperator.ExpressionEvaluator base;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ToLongBaseEvaluator(Source source, EvalOperator.ExpressionEvaluator string, EvalOperator.ExpressionEvaluator base, DriverContext driverContext) {
        this.source = source;
        this.string = string;
        this.base = base;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock stringBlock = (BytesRefBlock)this.string.eval(page);){
            LongBlock longBlock;
            block20: {
                IntVector baseVector;
                BytesRefVector stringVector;
                IntBlock baseBlock;
                block18: {
                    LongBlock longBlock2;
                    block19: {
                        block16: {
                            LongBlock longBlock3;
                            block17: {
                                baseBlock = (IntBlock)this.base.eval(page);
                                try {
                                    stringVector = stringBlock.asVector();
                                    if (stringVector != null) break block16;
                                    longBlock3 = this.eval(page.getPositionCount(), stringBlock, baseBlock);
                                    if (baseBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (baseBlock != null) {
                                        try {
                                            baseBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                baseBlock.close();
                            }
                            return longBlock3;
                        }
                        baseVector = baseBlock.asVector();
                        if (baseVector != null) break block18;
                        longBlock2 = this.eval(page.getPositionCount(), stringBlock, baseBlock);
                        if (baseBlock == null) break block19;
                        baseBlock.close();
                    }
                    return longBlock2;
                }
                longBlock = this.eval(page.getPositionCount(), stringVector, baseVector);
                if (baseBlock == null) break block20;
                baseBlock.close();
            }
            return longBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.string.baseRamBytesUsed();
        return baseRamBytesUsed += this.base.baseRamBytesUsed();
    }

    public LongBlock eval(int positionCount, BytesRefBlock stringBlock, IntBlock baseBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            BytesRef stringScratch = new BytesRef();
            block15: for (int p = 0; p < positionCount; ++p) {
                switch (stringBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block15;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block15;
                    }
                }
                switch (baseBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block15;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block15;
                    }
                }
                BytesRef string = stringBlock.getBytesRef(stringBlock.getFirstValueIndex(p), stringScratch);
                int base = baseBlock.getInt(baseBlock.getFirstValueIndex(p));
                try {
                    result.appendLong(ToLongBase.process(string, base));
                    continue;
                }
                catch (InvalidArgumentException e) {
                    this.warnings().registerException((Exception)((Object)e));
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, BytesRefVector stringVector, IntVector baseVector) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            BytesRef stringScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                BytesRef string = stringVector.getBytesRef(p, stringScratch);
                int base = baseVector.getInt(p);
                try {
                    result.appendLong(ToLongBase.process(string, base));
                    continue;
                }
                catch (InvalidArgumentException e) {
                    this.warnings().registerException((Exception)((Object)e));
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public String toString() {
        return "ToLongBaseEvaluator[string=" + String.valueOf(this.string) + ", base=" + String.valueOf(this.base) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.string, this.base});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory string;
        private final EvalOperator.ExpressionEvaluator.Factory base;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory string, EvalOperator.ExpressionEvaluator.Factory base) {
            this.source = source;
            this.string = string;
            this.base = base;
        }

        public ToLongBaseEvaluator get(DriverContext context) {
            return new ToLongBaseEvaluator(this.source, this.string.get(context), this.base.get(context), context);
        }

        public String toString() {
            return "ToLongBaseEvaluator[string=" + String.valueOf(this.string) + ", base=" + String.valueOf(this.base) + "]";
        }
    }
}

