/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongBaseEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class ToLongBase
extends EsqlScalarFunction {
    private static final TransportVersion ESQL_BASE_CONVERSION = TransportVersion.fromName((String)"esql_base_conversion");
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToLongBase", ToLongBase::new);
    private final Expression string;
    private final Expression base;

    public ToLongBase(Source source, Expression string, Expression base) {
        super(source, List.of(string, base));
        this.string = string;
        this.base = base;
    }

    private ToLongBase(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (!out.getTransportVersion().supports(ESQL_BASE_CONVERSION)) {
            throw new UnsupportedOperationException("version does not support to_long(string, base)");
        }
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.string);
        out.writeNamedWriteable((NamedWriteable)this.base);
    }

    public String getWriteableName() {
        return ToLongBase.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isString(this.string, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.resolved()) {
            resolution = TypeResolutions.isType(this.base, dt -> dt == DataType.INTEGER, this.sourceText(), TypeResolutions.ParamOrdinal.SECOND, "integer");
        }
        return resolution;
    }

    @Override
    public boolean foldable() {
        return this.string.foldable() && this.base.foldable();
    }

    static long process(BytesRef string, int base) {
        String value = string.utf8ToString();
        try {
            if (base == 10) {
                return EsqlDataTypeConverter.stringToLong(value);
            }
            if (base == 16 && value.startsWith("0x")) {
                value = value.substring(2);
            }
            return Long.parseLong(value, base);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException((Throwable)e, "Unable to convert [{}] to number of base [{}]", new Object[]{value, base});
        }
    }

    @Override
    public final Expression replaceChildren(List<Expression> newChildren) {
        return new ToLongBase(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, ToLongBase::new, this.string, this.base);
    }

    public Expression string() {
        return this.string;
    }

    public Expression base() {
        return this.base;
    }

    @Override
    public DataType dataType() {
        return DataType.LONG;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory stringEval = toEvaluator.apply(this.string);
        EvalOperator.ExpressionEvaluator.Factory baseEval = toEvaluator.apply(this.base);
        return new ToLongBaseEvaluator.Factory(this.source(), stringEval, baseEval);
    }
}

