/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.DataTypeConverter;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromStringEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class ToLong
extends AbstractConvertFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToLong", ToLong::new);
    static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.LONG, (source, fieldEval) -> fieldEval), Map.entry(DataType.DATETIME, (source, fieldEval) -> fieldEval), Map.entry(DataType.DATE_NANOS, (source, fieldEval) -> fieldEval), Map.entry(DataType.BOOLEAN, ToLongFromBooleanEvaluator.Factory::new), Map.entry(DataType.KEYWORD, ToLongFromStringEvaluator.Factory::new), Map.entry(DataType.TEXT, ToLongFromStringEvaluator.Factory::new), Map.entry(DataType.DOUBLE, ToLongFromDoubleEvaluator.Factory::new), Map.entry(DataType.UNSIGNED_LONG, ToLongFromUnsignedLongEvaluator.Factory::new), Map.entry(DataType.INTEGER, ToLongFromIntEvaluator.Factory::new), Map.entry(DataType.COUNTER_LONG, (source, field) -> field), Map.entry(DataType.COUNTER_INTEGER, ToLongFromIntEvaluator.Factory::new), Map.entry(DataType.GEOHASH, (source, fieldEval) -> fieldEval), Map.entry(DataType.GEOTILE, (source, fieldEval) -> fieldEval), Map.entry(DataType.GEOHEX, (source, fieldEval) -> fieldEval));

    public ToLong(Source source, Expression field) {
        super(source, field);
    }

    private ToLong(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return ToLong.ENTRY.name;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataType.LONG;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToLong(this.source(), newChildren.get(0));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, ToLong::new, this.field());
    }

    static long fromBoolean(boolean bool) {
        return bool ? 1L : 0L;
    }

    static long fromKeyword(BytesRef in) {
        return EsqlDataTypeConverter.stringToLong(in.utf8ToString());
    }

    static long fromDouble(double dbl) {
        return DataTypeConverter.safeDoubleToLong(dbl);
    }

    static long fromUnsignedLong(long ul) {
        return EsqlDataTypeConverter.unsignedLongToLong(ul);
    }

    static long fromInt(int i) {
        return i;
    }
}

