/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToInteger;

public final class ToIntegerFromUnsignedLongEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ToIntegerFromUnsignedLongEvaluator.class);
    private final EvalOperator.ExpressionEvaluator ul;

    public ToIntegerFromUnsignedLongEvaluator(Source source, EvalOperator.ExpressionEvaluator ul, DriverContext driverContext) {
        super(driverContext, source);
        this.ul = ul;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.ul;
    }

    @Override
    public Block evalVector(Vector v) {
        LongVector vector = (LongVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            try {
                return this.driverContext.blockFactory().newConstantIntBlockWith(this.evalValue(vector, 0), positionCount);
            }
            catch (InvalidArgumentException e) {
                this.registerException((Exception)((Object)e));
                return this.driverContext.blockFactory().newConstantNullBlock(positionCount);
            }
        }
        try (IntBlock.Builder builder = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    builder.appendInt(this.evalValue(vector, p));
                    continue;
                }
                catch (InvalidArgumentException e) {
                    this.registerException((Exception)((Object)e));
                    builder.appendNull();
                }
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    private int evalValue(LongVector container, int index) {
        long value = container.getLong(index);
        return ToInteger.fromUnsignedLong(value);
    }

    @Override
    public Block evalBlock(Block b) {
        LongBlock block = (LongBlock)b;
        int positionCount = block.getPositionCount();
        try (IntBlock.Builder builder = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    try {
                        int value = this.evalValue(block, i);
                        if (!positionOpened && valueCount > 1) {
                            builder.beginPositionEntry();
                            positionOpened = true;
                        }
                        builder.appendInt(value);
                        valuesAppended = true;
                        continue;
                    }
                    catch (InvalidArgumentException e) {
                        this.registerException((Exception)((Object)e));
                    }
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    private int evalValue(LongBlock container, int index) {
        long value = container.getLong(index);
        return ToInteger.fromUnsignedLong(value);
    }

    public String toString() {
        return "ToIntegerFromUnsignedLongEvaluator[ul=" + String.valueOf(this.ul) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.ul);
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.ul.baseRamBytesUsed();
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory ul;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory ul) {
            this.source = source;
            this.ul = ul;
        }

        public ToIntegerFromUnsignedLongEvaluator get(DriverContext context) {
            return new ToIntegerFromUnsignedLongEvaluator(this.source, this.ul.get(context), context);
        }

        public String toString() {
            return "ToIntegerFromUnsignedLongEvaluator[ul=" + String.valueOf(this.ul) + "]";
        }
    }
}

