/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.DataTypeConverter;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIntegerFromBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIntegerFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIntegerFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIntegerFromStringEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIntegerFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class ToInteger
extends AbstractConvertFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToInteger", ToInteger::new);
    static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.INTEGER, (source, fieldEval) -> fieldEval), Map.entry(DataType.BOOLEAN, ToIntegerFromBooleanEvaluator.Factory::new), Map.entry(DataType.DATETIME, ToIntegerFromLongEvaluator.Factory::new), Map.entry(DataType.KEYWORD, ToIntegerFromStringEvaluator.Factory::new), Map.entry(DataType.TEXT, ToIntegerFromStringEvaluator.Factory::new), Map.entry(DataType.DOUBLE, ToIntegerFromDoubleEvaluator.Factory::new), Map.entry(DataType.UNSIGNED_LONG, ToIntegerFromUnsignedLongEvaluator.Factory::new), Map.entry(DataType.LONG, ToIntegerFromLongEvaluator.Factory::new), Map.entry(DataType.COUNTER_INTEGER, (source, fieldEval) -> fieldEval));

    public ToInteger(Source source, Expression field) {
        super(source, field);
    }

    private ToInteger(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return ToInteger.ENTRY.name;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataType.INTEGER;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToInteger(this.source(), newChildren.get(0));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, ToInteger::new, this.field());
    }

    static int fromBoolean(boolean bool) {
        return bool ? 1 : 0;
    }

    static int fromKeyword(BytesRef in) {
        return EsqlDataTypeConverter.stringToInt(in.utf8ToString());
    }

    static int fromDouble(double dbl) {
        return DataTypeConverter.safeToInt(dbl);
    }

    static int fromUnsignedLong(long ul) {
        return EsqlDataTypeConverter.unsignedLongToInt(ul);
    }

    static int fromLong(long lng) {
        return DataTypeConverter.safeToInt(lng);
    }
}

