/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToGeotileFromStringEvaluator;

public class ToGeotile
extends AbstractConvertFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToGeotile", ToGeotile::new);
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.GEOTILE, (source, fieldEval) -> fieldEval), Map.entry(DataType.LONG, (source, fieldEval) -> fieldEval), Map.entry(DataType.KEYWORD, ToGeotileFromStringEvaluator.Factory::new), Map.entry(DataType.TEXT, ToGeotileFromStringEvaluator.Factory::new));

    @FunctionInfo(returnType={"geotile"}, preview=true, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW)}, description="Converts an input value to a `geotile` value.\nA string will only be successfully converted if it respects the\n`geotile` format, as described for the\n[geotile grid aggregation](/reference/aggregations/search-aggregations-bucket-geotilegrid-aggregation.md).", examples={@Example(file="spatial-grid", tag="to_geotile")})
    public ToGeotile(Source source, @Param(name="field", type={"geotile", "long", "keyword", "text"}, description="Input value. The input can be a single- or multi-valued column or an expression.") Expression field) {
        super(source, field);
    }

    private ToGeotile(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return ToGeotile.ENTRY.name;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataType.GEOTILE;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToGeotile(this.source(), newChildren.get(0));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, ToGeotile::new, this.field());
    }

    static long fromString(BytesRef in) {
        return GeoTileUtils.longEncode((String)in.utf8ToString());
    }
}

