/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.h3.H3;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToGeohexFromStringEvaluator;

public class ToGeohex
extends AbstractConvertFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToGeohex", ToGeohex::new);
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.GEOHEX, (source, fieldEval) -> fieldEval), Map.entry(DataType.LONG, (source, fieldEval) -> fieldEval), Map.entry(DataType.KEYWORD, ToGeohexFromStringEvaluator.Factory::new), Map.entry(DataType.TEXT, ToGeohexFromStringEvaluator.Factory::new));

    @FunctionInfo(returnType={"geohex"}, preview=true, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW)}, description="Converts an input value to a `geohex` value.\nA string will only be successfully converted if it respects the\n`geohex` format, as described for the\n[geohex grid aggregation](/reference/aggregations/search-aggregations-bucket-geohexgrid-aggregation.md).", examples={@Example(file="spatial-grid", tag="to_geohex")})
    public ToGeohex(Source source, @Param(name="field", type={"geohex", "long", "keyword", "text"}, description="Input value. The input can be a single- or multi-valued column or an expression.") Expression field) {
        super(source, field);
    }

    private ToGeohex(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return ToGeohex.ENTRY.name;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataType.GEOHEX;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToGeohex(this.source(), newChildren.get(0));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, ToGeohex::new, this.field());
    }

    static long fromString(BytesRef in) {
        return H3.stringToH3((String)in.utf8ToString());
    }
}

