/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.capabilities.PostOptimizationVerificationAware;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.Validations;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public abstract class FoldablesConvertFunction
extends AbstractConvertFunction
implements PostOptimizationVerificationAware {
    protected FoldablesConvertFunction(Source source, Expression field) {
        super(source, field);
    }

    @Override
    public final void writeTo(StreamOutput out) {
        throw new UnsupportedOperationException("not serialized");
    }

    public final String getWriteableName() {
        throw new UnsupportedOperationException("not serialized");
    }

    @Override
    protected final Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isType(this.field(), dt -> DataType.isString(dt) || dt == this.dataType(), this.sourceText(), null, false, this.dataType().typeName().toLowerCase(Locale.ROOT) + " or string");
    }

    @Override
    protected final Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return Map.of();
    }

    @Override
    public final Object fold(FoldContext ctx) {
        return EsqlDataTypeConverter.foldToTemporalAmount(ctx, this.field(), this.sourceText(), this.dataType());
    }

    @Override
    public final void postOptimizationVerification(Failures failures) {
        failures.add(Validations.isFoldable(this.field(), this.sourceText(), null));
    }
}

