/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMinBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMinBytesRefEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMinDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMinIntegerEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMinLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class ClampMin
extends EsqlScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ClampMin", ClampMin::new);
    private DataType resolvedType;

    @FunctionInfo(returnType={"double", "integer", "long", "double", "unsigned_long", "keyword", "ip", "boolean", "date", "version"}, description="Limits (or clamps) all input sample values to a lower bound of min. Any value below min is set to min.", examples={@Example(file="k8s-timeseries-clamp", tag="clamp-min")}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.3.0")})
    public ClampMin(Source source, @Param(name="field", type={"double", "integer", "long", "double", "unsigned_long", "keyword", "ip", "boolean", "date", "version"}, description="field to clamp.") Expression field, @Param(name="min", type={"double", "integer", "long", "double", "unsigned_long", "keyword", "ip", "boolean", "date", "version"}, description="The min value to clamp data into.") Expression min) {
        super(source, List.of(field, min));
    }

    private ClampMin(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.children().get(0));
        out.writeNamedWriteable((NamedWriteable)this.children().get(1));
    }

    public String getWriteableName() {
        return ClampMin.ENTRY.name;
    }

    @Override
    public DataType dataType() {
        if (this.resolvedType == null && !this.resolveType().resolved()) {
            throw new EsqlIllegalArgumentException("Unable to resolve data type for clamp_min");
        }
        return this.resolvedType;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression field = (Expression)this.children().get(0);
        Expression min = (Expression)this.children().get(1);
        DataType fieldDataType = field.dataType().noText();
        Expression.TypeResolution resolution = TypeResolutions.isType(field, t -> t.isNumeric() || t == DataType.BOOLEAN || t.isDate() || DataType.isString(t) || t == DataType.IP || t == DataType.VERSION, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST, fieldDataType.typeName());
        if (resolution.unresolved()) {
            return resolution;
        }
        if (fieldDataType == DataType.NULL) {
            return new Expression.TypeResolution("'field' must not be null in clamp()");
        }
        resolution = TypeResolutions.isType(min, t -> t.isNumeric() ? fieldDataType.isNumeric() : t.noText() == fieldDataType.noText(), this.sourceText(), TypeResolutions.ParamOrdinal.SECOND, fieldDataType.typeName());
        if (resolution.unresolved()) {
            return resolution;
        }
        this.resolvedType = !fieldDataType.isNumeric() ? fieldDataType : (fieldDataType.estimatedSize() == min.dataType().estimatedSize() ? (fieldDataType.isRationalNumber() ? fieldDataType : min.dataType()) : (fieldDataType.estimatedSize() > min.dataType().estimatedSize() ? fieldDataType : min.dataType()));
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new ClampMin(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, ClampMin::new, (Expression)this.children().get(0), (Expression)this.children().get(1));
    }

    @Override
    public boolean foldable() {
        return Expressions.foldable(this.children());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        ElementType outputType = PlannerUtils.toElementType(this.dataType());
        EvalOperator.ExpressionEvaluator.Factory fieldEval = PlannerUtils.toElementType(((Expression)this.children().getFirst()).dataType()) != outputType ? Cast.cast(this.source(), ((Expression)this.children().getFirst()).dataType(), this.dataType(), toEvaluator.apply((Expression)this.children().get(0))) : toEvaluator.apply((Expression)this.children().getFirst());
        EvalOperator.ExpressionEvaluator.Factory minEval = PlannerUtils.toElementType(((Expression)this.children().get(1)).dataType()) != outputType ? Cast.cast(this.source(), ((Expression)this.children().get(1)).dataType(), this.dataType(), toEvaluator.apply((Expression)this.children().get(1))) : toEvaluator.apply((Expression)this.children().get(1));
        return switch (outputType) {
            case ElementType.BOOLEAN -> new ClampMinBooleanEvaluator.Factory(this.source(), fieldEval, minEval);
            case ElementType.DOUBLE -> new ClampMinDoubleEvaluator.Factory(this.source(), fieldEval, minEval);
            case ElementType.INT -> new ClampMinIntegerEvaluator.Factory(this.source(), fieldEval, minEval);
            case ElementType.LONG -> new ClampMinLongEvaluator.Factory(this.source(), fieldEval, minEval);
            case ElementType.BYTES_REF -> new ClampMinBytesRefEvaluator.Factory(this.source(), fieldEval, minEval);
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.dataType());
        };
    }

    static boolean process(boolean field, boolean min) {
        if (min) {
            return true;
        }
        return field;
    }

    static BytesRef process(BytesRef field, BytesRef min) {
        return field.compareTo(min) < 0 ? min : field;
    }

    static int process(int field, int min) {
        return Math.max(field, min);
    }

    static long process(long field, long min) {
        return Math.max(field, min);
    }

    static double process(double field, double min) {
        return Math.max(field, min);
    }
}

