/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.grouping;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.esql.LicenseAware;
import org.elasticsearch.xpack.esql.SupportsObservabilityTier;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.MapExpression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.MapParam;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Options;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.InlineStats;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ml.MachineLearning;

@SupportsObservabilityTier(tier=SupportsObservabilityTier.ObservabilityTier.COMPLETE)
public class Categorize
extends GroupingFunction.NonEvaluatableGroupingFunction
implements OptionalArgument,
LicenseAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Categorize", Categorize::new);
    private static final TransportVersion ESQL_CATEGORIZE_OPTIONS = TransportVersion.fromName((String)"esql_categorize_options");
    private static final String ANALYZER = "analyzer";
    private static final String OUTPUT_FORMAT = "output_format";
    private static final String SIMILARITY_THRESHOLD = "similarity_threshold";
    private static final Map<String, DataType> ALLOWED_OPTIONS = new TreeMap<String, DataType>(Map.ofEntries(Map.entry("analyzer", DataType.KEYWORD), Map.entry("output_format", DataType.KEYWORD), Map.entry("similarity_threshold", DataType.INTEGER)));
    private final Expression field;
    private final Expression options;

    @FunctionInfo(returnType={"keyword"}, description="Groups text messages into categories of similarly formatted text values.", detailedDescription="`CATEGORIZE` has the following limitations:\n\n* can\u2019t be used within other expressions\n* can\u2019t be used more than once in the groupings\n* can\u2019t be used or referenced within aggregate functions and it has to be the first grouping", examples={@Example(file="docs", tag="docsCategorize", description="This example categorizes server logs messages into categories and aggregates their counts. ")}, type=FunctionType.GROUPING, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.0"), @FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.GA, version="9.1")})
    public Categorize(Source source, @Param(name="field", type={"text", "keyword"}, description="Expression to categorize") Expression field, @MapParam(name="options", description="(Optional) Categorize additional options as <<esql-function-named-params,function named parameters>>. {applies_to}`stack: ga 9.2`}", params={@MapParam.MapParamEntry(name="analyzer", type={"keyword"}, valueHint={"standard"}, description="Analyzer used to convert the field into tokens for text categorization."), @MapParam.MapParamEntry(name="output_format", type={"keyword"}, valueHint={"regex", "tokens"}, description="The output format of the categories. Defaults to regex."), @MapParam.MapParamEntry(name="similarity_threshold", type={"integer"}, valueHint={"70"}, description="The minimum percentage of token weight that must match for text to be added to the category bucket. Must be between 1 and 100. The larger the value the narrower the categories. Larger values will increase memory usage and create narrower categories. Defaults to 70.")}, optional=true) Expression options) {
        super(source, options == null ? List.of(field) : List.of(field, options));
        this.field = field;
        this.options = options;
    }

    private Categorize(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), in.getTransportVersion().supports(ESQL_CATEGORIZE_OPTIONS) ? (Expression)in.readOptionalNamedWriteable(Expression.class) : null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
        if (out.getTransportVersion().supports(ESQL_CATEGORIZE_OPTIONS)) {
            out.writeOptionalNamedWriteable((NamedWriteable)this.options);
        }
    }

    public String getWriteableName() {
        return Categorize.ENTRY.name;
    }

    @Override
    public boolean foldable() {
        return false;
    }

    @Override
    public Nullability nullable() {
        return Nullability.TRUE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isString(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT).and(Options.resolve(this.options, this.source(), TypeResolutions.ParamOrdinal.SECOND, ALLOWED_OPTIONS, this::verifyOptions));
    }

    private void verifyOptions(Map<String, Object> optionsMap) {
        if (this.options == null) {
            return;
        }
        Integer similarityThreshold = (Integer)optionsMap.get(SIMILARITY_THRESHOLD);
        if (similarityThreshold != null && (similarityThreshold <= 0 || similarityThreshold > 100)) {
            throw new InvalidArgumentException(LoggerMessageFormat.format((String)"invalid similarity threshold [{}], expecting a number between 1 and 100, inclusive", (Object[])new Object[]{similarityThreshold}), new Object[0]);
        }
        String outputFormat = (String)optionsMap.get(OUTPUT_FORMAT);
        if (outputFormat != null) {
            try {
                BlockHash.CategorizeDef.OutputFormat.valueOf((String)outputFormat.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new InvalidArgumentException(LoggerMessageFormat.format(null, (String)"invalid output format [{}], expecting one of [REGEX, TOKENS]", (Object[])new Object[]{outputFormat}), new Object[0]);
            }
        }
    }

    public BlockHash.CategorizeDef categorizeDef() {
        HashMap<String, Object> optionsMap = new HashMap<String, Object>();
        if (this.options != null) {
            Options.populateMap((MapExpression)this.options, optionsMap, this.source(), TypeResolutions.ParamOrdinal.SECOND, ALLOWED_OPTIONS);
        }
        Integer similarityThreshold = (Integer)optionsMap.get(SIMILARITY_THRESHOLD);
        String outputFormatString = (String)optionsMap.get(OUTPUT_FORMAT);
        BlockHash.CategorizeDef.OutputFormat outputFormat = outputFormatString == null ? null : BlockHash.CategorizeDef.OutputFormat.valueOf((String)outputFormatString.toUpperCase(Locale.ROOT));
        return new BlockHash.CategorizeDef((String)optionsMap.get(ANALYZER), outputFormat == null ? BlockHash.CategorizeDef.OutputFormat.REGEX : outputFormat, similarityThreshold == null ? 70 : similarityThreshold);
    }

    @Override
    public DataType dataType() {
        return DataType.KEYWORD;
    }

    @Override
    public Categorize replaceChildren(List<Expression> newChildren) {
        return new Categorize(this.source(), newChildren.get(0), newChildren.size() > 1 ? newChildren.get(1) : null);
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Categorize::new, this.field, this.options);
    }

    public Expression field() {
        return this.field;
    }

    @Override
    public String toString() {
        return "Categorize{field=" + String.valueOf(this.field) + "}";
    }

    @Override
    public boolean licenseCheck(XPackLicenseState state) {
        return MachineLearning.CATEGORIZE_TEXT_AGG_FEATURE.check(state);
    }

    @Override
    public BiConsumer<LogicalPlan, Failures> postAnalysisPlanVerification() {
        return (p, failures) -> {
            InlineStats inlineStats;
            LogicalPlan patt0$temp;
            super.postAnalysisPlanVerification().accept((LogicalPlan)p, (Failures)failures);
            if (p instanceof InlineStats && (patt0$temp = (inlineStats = (InlineStats)p).child()) instanceof Aggregate) {
                Aggregate aggregate = (Aggregate)patt0$temp;
                aggregate.groupings().forEach(grp -> {
                    Alias alias;
                    Expression patt0$temp;
                    if (grp instanceof Alias && (patt0$temp = (alias = (Alias)grp).child()) instanceof Categorize) {
                        Categorize categorize = (Categorize)patt0$temp;
                        failures.add(Failure.fail(categorize, "CATEGORIZE [{}] is not yet supported with INLINE STATS [{}]", categorize.sourceText(), inlineStats.sourceText()));
                    }
                });
            }
        };
    }
}

