/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.fulltext;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ResolvedIndices;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.xpack.esql.capabilities.RewriteableAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.plugin.TransportActionServices;
import org.elasticsearch.xpack.esql.session.IndexResolver;

public final class QueryBuilderResolver {
    private QueryBuilderResolver() {
    }

    public static void resolveQueryBuilders(LogicalPlan plan, TransportActionServices services, ActionListener<LogicalPlan> listener) {
        boolean hasRewriteableAwareFunctions = plan.anyMatch(p -> {
            Holder hasRewriteable = new Holder((Object)false);
            p.forEachExpression(expr -> {
                if (expr instanceof RewriteableAware) {
                    hasRewriteable.set((Object)true);
                }
            });
            return (Boolean)hasRewriteable.get();
        });
        if (hasRewriteableAwareFunctions) {
            Rewriteable.rewriteAndFetch((Rewriteable)new FunctionsRewriteable(plan), (QueryRewriteContext)QueryBuilderResolver.queryRewriteContext(services, QueryBuilderResolver.indexNames(plan)), (ActionListener)listener.delegateFailureAndWrap((l, r) -> l.onResponse((Object)r.plan)));
        } else {
            listener.onResponse((Object)plan);
        }
    }

    private static QueryRewriteContext queryRewriteContext(TransportActionServices services, Set<String> indexNames) {
        ClusterState clusterState = services.clusterService().state();
        ResolvedIndices resolvedIndices = ResolvedIndices.resolveWithIndexNamesAndOptions((String[])((String[])indexNames.toArray(String[]::new)), (IndicesOptions)IndexResolver.DEFAULT_OPTIONS, (ProjectMetadata)services.projectResolver().getProjectMetadata(clusterState), (IndexNameExpressionResolver)services.indexNameExpressionResolver(), (RemoteClusterService)services.transportService().getRemoteClusterService(), (long)System.currentTimeMillis());
        return services.searchService().getRewriteContext(System::currentTimeMillis, clusterState.getMinTransportVersion(), "", resolvedIndices, null, Boolean.valueOf(false));
    }

    private static Set<String> indexNames(LogicalPlan plan) {
        HashSet<String> indexNames = new HashSet<String>();
        plan.forEachDown(EsRelation.class, esRelation -> indexNames.addAll(esRelation.concreteQualifiedIndices()));
        return indexNames;
    }

    private record FunctionsRewriteable(LogicalPlan plan) implements Rewriteable<FunctionsRewriteable>
    {
        public FunctionsRewriteable rewrite(QueryRewriteContext ctx) throws IOException {
            Holder exceptionHolder = new Holder();
            Holder updated = new Holder((Object)false);
            LogicalPlan newPlan = (LogicalPlan)this.plan.transformExpressionsDown(Expression.class, expr -> {
                Expression finalExpression = expr;
                if (expr instanceof RewriteableAware) {
                    QueryBuilder builder;
                    RewriteableAware rewriteableAware = (RewriteableAware)((Object)expr);
                    QueryBuilder initial = builder = rewriteableAware.queryBuilder();
                    builder = builder == null ? rewriteableAware.asQuery(LucenePushdownPredicates.DEFAULT, TranslatorHandler.TRANSLATOR_HANDLER).toQueryBuilder() : builder;
                    try {
                        builder = builder.rewrite(ctx);
                    }
                    catch (IOException e) {
                        exceptionHolder.setIfAbsent((Object)e);
                    }
                    boolean rewritten = builder != initial;
                    updated.set((Object)((Boolean)updated.get() != false || rewritten ? 1 : 0));
                    finalExpression = rewritten ? rewriteableAware.replaceQueryBuilder(builder) : finalExpression;
                }
                return finalExpression;
            });
            if (exceptionHolder.get() != null) {
                throw (IOException)exceptionHolder.get();
            }
            return (Boolean)updated.get() != false ? new FunctionsRewriteable(newPlan) : this;
        }
    }
}

