/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.fulltext;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.MapExpression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Check;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.MapParam;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Options;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.fulltext.SingleFieldFullTextFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.querydsl.query.MatchPhraseQuery;

public class MatchPhrase
extends SingleFieldFullTextFunction
implements OptionalArgument {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MatchPhrase", MatchPhrase::readFrom);
    public static final Set<DataType> FIELD_DATA_TYPES = Set.of(DataType.KEYWORD, DataType.TEXT, DataType.NULL);
    public static final Set<DataType> QUERY_DATA_TYPES = Set.of(DataType.KEYWORD, DataType.TEXT);
    public static final Map<String, DataType> ALLOWED_OPTIONS = Map.ofEntries(Map.entry(MatchQueryBuilder.ANALYZER_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(AbstractQueryBuilder.BOOST_FIELD.getPreferredName(), DataType.FLOAT), Map.entry(MatchPhraseQueryBuilder.SLOP_FIELD.getPreferredName(), DataType.INTEGER), Map.entry(MatchPhraseQueryBuilder.ZERO_TERMS_QUERY_FIELD.getPreferredName(), DataType.KEYWORD));

    @FunctionInfo(returnType={"boolean"}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.GA, version="9.1.0")}, description="Use `MATCH_PHRASE` to perform a [`match_phrase`](/reference/query-languages/query-dsl/query-dsl-match-query-phrase.md) on the\nspecified field.\nUsing `MATCH_PHRASE` is equivalent to using the `match_phrase` query in the Elasticsearch Query DSL.", detailedDescription="MatchPhrase can be used on <<text, text>> fields, as well as other field types like keyword, boolean, or date types.\nMatchPhrase is not supported for <<semantic-text, semantic_text>> or numeric types.\n\nMatchPhrase can use <<esql-function-named-params,function named parameters>> to specify additional options for the\nmatch_phrase query.\nAll [`match_phrase`](/reference/query-languages/query-dsl/query-dsl-match-query-phrase.md) query parameters are supported.\n\n`MATCH_PHRASE` returns true if the provided query matches the row.", examples={@Example(file="match-phrase-function", tag="match-phrase-with-field", applies_to="stack: ga 9.1.0")})
    public MatchPhrase(Source source, @Param(name="field", type={"keyword", "text"}, description="Field that the query will target.") Expression field, @Param(name="query", type={"keyword"}, description="Value to find in the provided field.") Expression matchPhraseQuery, @MapParam(name="options", params={@MapParam.MapParamEntry(name="analyzer", type={"keyword"}, valueHint={"standard"}, description="Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index\u2019s default analyzer is used."), @MapParam.MapParamEntry(name="slop", type={"integer"}, valueHint={"1"}, description="Maximum number of positions allowed between matching tokens. Defaults to 0. Transposed terms have a slop of 2."), @MapParam.MapParamEntry(name="zero_terms_query", type={"keyword"}, valueHint={"none", "all"}, description="Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none."), @MapParam.MapParamEntry(name="boost", type={"float"}, valueHint={"2.5"}, description="Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.")}, description="(Optional) MatchPhrase additional options as <<esql-function-named-params,function named parameters>>. See [`match_phrase`](/reference/query-languages/query-dsl/query-dsl-match-query-phrase.md) for more information.", optional=true) Expression options) {
        this(source, field, matchPhraseQuery, options, null);
    }

    public MatchPhrase(Source source, Expression field, Expression matchPhraseQuery, Expression options, QueryBuilder queryBuilder) {
        super(source, field, matchPhraseQuery, options, options == null ? List.of(field, matchPhraseQuery) : List.of(field, matchPhraseQuery, options), queryBuilder);
    }

    public String getWriteableName() {
        return MatchPhrase.ENTRY.name;
    }

    @Override
    public String functionName() {
        return MatchPhrase.ENTRY.name;
    }

    private static MatchPhrase readFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((PlanStreamInput)in);
        Expression field = (Expression)in.readNamedWriteable(Expression.class);
        Expression query = (Expression)in.readNamedWriteable(Expression.class);
        QueryBuilder queryBuilder = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        return new MatchPhrase(source, field, query, null, queryBuilder);
    }

    public final void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field());
        out.writeNamedWriteable((NamedWriteable)this.query());
        out.writeOptionalNamedWriteable((NamedWriteable)this.queryBuilder());
    }

    @Override
    protected Set<DataType> getFieldDataTypes() {
        return FIELD_DATA_TYPES;
    }

    @Override
    protected Set<DataType> getQueryDataTypes() {
        return QUERY_DATA_TYPES;
    }

    @Override
    protected Map<String, DataType> getAllowedOptions() {
        return ALLOWED_OPTIONS;
    }

    private Map<String, Object> matchPhraseQueryOptions() throws InvalidArgumentException {
        if (this.options() == null) {
            return Map.of();
        }
        HashMap<String, Object> matchPhraseOptions = new HashMap<String, Object>();
        Options.populateMap((MapExpression)this.options(), matchPhraseOptions, this.source(), TypeResolutions.ParamOrdinal.SECOND, ALLOWED_OPTIONS);
        return matchPhraseOptions;
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, MatchPhrase::new, this.field(), this.query(), this.options(), this.queryBuilder());
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new MatchPhrase(this.source(), newChildren.get(0), newChildren.get(1), newChildren.size() > 2 ? newChildren.get(2) : null, this.queryBuilder());
    }

    @Override
    public Expression replaceQueryBuilder(QueryBuilder queryBuilder) {
        return new MatchPhrase(this.source(), this.field, this.query(), this.options(), queryBuilder);
    }

    @Override
    protected Query translate(LucenePushdownPredicates pushdownPredicates, TranslatorHandler handler) {
        FieldAttribute fieldAttribute = this.fieldAsFieldAttribute();
        Check.notNull(fieldAttribute, "MatchPhrase must have a field attribute as the first argument");
        String fieldName = this.getNameFromFieldAttribute(fieldAttribute);
        return new MatchPhraseQuery(this.source(), fieldName, this.queryAsObject(), this.matchPhraseQueryOptions());
    }
}

