/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.fulltext;

import java.io.IOException;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.MapExpression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.expression.function.ConfigurationFunction;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.MapParam;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Options;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.fulltext.FullTextFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.querydsl.query.KqlQuery;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.kql.query.KqlQueryBuilder;

public class Kql
extends FullTextFunction
implements OptionalArgument,
ConfigurationFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Kql", Kql::readFrom);
    private final Configuration configuration;
    private final transient Expression options;
    public static final Map<String, DataType> ALLOWED_OPTIONS = Map.ofEntries(Map.entry(AbstractQueryBuilder.BOOST_FIELD.getPreferredName(), DataType.FLOAT), Map.entry(KqlQueryBuilder.CASE_INSENSITIVE_FIELD.getPreferredName(), DataType.BOOLEAN), Map.entry(KqlQueryBuilder.TIME_ZONE_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(KqlQueryBuilder.DEFAULT_FIELD_FIELD.getPreferredName(), DataType.KEYWORD));

    @FunctionInfo(returnType={"boolean"}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.0.0"), @FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.GA, version="9.1.0")}, description="Performs a KQL query. Returns true if the provided KQL query string matches the row.", examples={@Example(file="kql-function", tag="kql-with-field", description="Use KQL to filter by a specific field value"), @Example(file="kql-function", tag="kql-with-options", description="Use KQL with additional options for case-insensitive matching and custom settings", applies_to="stack: ga 9.3.0")})
    public Kql(Source source, @Param(name="query", type={"keyword", "text"}, description="Query string in KQL query string format.") Expression queryString, @MapParam(name="options", description="(Optional) KQL additional options as <<esql-function-named-params,function named parameters>>. Available in stack version 9.3.0 and later.", params={@MapParam.MapParamEntry(name="case_insensitive", type={"boolean"}, valueHint={"true", "false"}, description="If true, performs case-insensitive matching for keyword fields. Defaults to false."), @MapParam.MapParamEntry(name="time_zone", type={"keyword"}, valueHint={"UTC", "Europe/Paris", "America/New_York"}, description="UTC offset or IANA time zone used to interpret date literals in the query string."), @MapParam.MapParamEntry(name="default_field", type={"keyword"}, valueHint={"*", "logs.*", "title"}, description="Default field to search if no field is provided in the query string. Supports wildcards (*)."), @MapParam.MapParamEntry(name="boost", type={"float"}, valueHint={"2.5"}, description="Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.")}, optional=true) Expression options, Configuration configuration) {
        this(source, queryString, options, null, configuration);
    }

    public Kql(Source source, Expression queryString, Expression options, QueryBuilder queryBuilder, Configuration configuration) {
        super(source, queryString, options == null ? List.of(queryString) : List.of(queryString, options), queryBuilder);
        this.configuration = configuration;
        this.options = options;
    }

    private static Kql readFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((PlanStreamInput)in);
        Expression query = (Expression)in.readNamedWriteable(Expression.class);
        QueryBuilder queryBuilder = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        return new Kql(source, query, null, queryBuilder, ((PlanStreamInput)in).configuration());
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.query());
        out.writeOptionalNamedWriteable((NamedWriteable)this.queryBuilder());
    }

    public String getWriteableName() {
        return Kql.ENTRY.name;
    }

    public Expression options() {
        return this.options;
    }

    private Expression.TypeResolution resolveQuery() {
        Expression.TypeResolution result = TypeResolutions.isType(this.query(), t -> t == DataType.KEYWORD || t == DataType.TEXT, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST, "keyword, text").and(TypeResolutions.isNotNull(this.query(), this.sourceText(), TypeResolutions.ParamOrdinal.FIRST));
        if (result.unresolved()) {
            return result;
        }
        result = Foldables.resolveTypeQuery(this.query(), this.sourceText(), Foldables.TypeResolutionValidator.forPreOptimizationValidation(this.query()));
        if (!result.equals(Expression.TypeResolution.TYPE_RESOLVED)) {
            return result;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    @Override
    protected Expression.TypeResolution resolveParams() {
        return this.resolveQuery().and(Options.resolve(this.options(), this.source(), TypeResolutions.ParamOrdinal.SECOND, ALLOWED_OPTIONS));
    }

    private Map<String, Object> kqlQueryOptions() throws InvalidArgumentException {
        if (this.options() == null && this.configuration.zoneId().equals(ZoneOffset.UTC)) {
            return null;
        }
        HashMap<String, Object> kqlOptions = new HashMap<String, Object>();
        if (this.options() != null) {
            Options.populateMap((MapExpression)this.options(), kqlOptions, this.source(), TypeResolutions.ParamOrdinal.SECOND, ALLOWED_OPTIONS);
        }
        kqlOptions.putIfAbsent(KqlQueryBuilder.TIME_ZONE_FIELD.getPreferredName(), this.configuration.zoneId().getId());
        return kqlOptions;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new Kql(this.source(), newChildren.get(0), newChildren.size() > 1 ? newChildren.get(1) : null, this.queryBuilder(), this.configuration);
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Kql::new, this.query(), this.options(), this.queryBuilder(), this.configuration);
    }

    @Override
    protected Query translate(LucenePushdownPredicates pushdownPredicates, TranslatorHandler handler) {
        return new KqlQuery(this.source(), Foldables.queryAsString(this.query(), this.sourceText()), this.kqlQueryOptions());
    }

    @Override
    public Expression replaceQueryBuilder(QueryBuilder queryBuilder) {
        return new Kql(this.source(), this.query(), this.options(), queryBuilder, this.configuration);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Kql kql = (Kql)o;
        return Objects.equals(this.query(), kql.query()) && Objects.equals(this.queryBuilder(), kql.queryBuilder()) && Objects.equals(this.configuration, kql.configuration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.query(), this.queryBuilder(), this.configuration);
    }

    @Override
    public String toString() {
        return "Kql{query=" + String.valueOf(this.query()) + (String)(this.options == null ? "" : ", options=" + String.valueOf(this.options)) + "}";
    }
}

