/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Source;

public enum SummationMode {
    COMPENSATED("compensated"),
    LOSSY("lossy");

    public static final Literal COMPENSATED_LITERAL;
    public static final Literal LOSSY_LITERAL;
    private final String mode;

    private SummationMode(String mode) {
        this.mode = mode;
    }

    private Literal asLiteral() {
        return Literal.keyword(Source.EMPTY, this.mode);
    }

    public static SummationMode fromLiteral(Expression literal) {
        return SummationMode.fromString(BytesRefs.toString((Object)literal.fold(FoldContext.small())));
    }

    private static SummationMode fromString(String mode) {
        return switch (mode) {
            case "compensated" -> COMPENSATED;
            case "lossy" -> LOSSY;
            default -> throw new IllegalArgumentException("unknown summation mode [" + mode + "]");
        };
    }

    static {
        COMPENSATED_LITERAL = COMPENSATED.asLiteral();
        LOSSY_LITERAL = LOSSY.asLiteral();
    }
}

