/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.RateDoubleGroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.RateIntGroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.RateLongGroupingAggregatorFunction;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.TimestampAware;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Rate
extends TimeSeriesAggregateFunction
implements OptionalArgument,
ToAggregator,
TimestampAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Rate", Rate::new);
    private final Expression timestamp;

    @FunctionInfo(type=FunctionType.TIME_SERIES_AGGREGATE, returnType={"double"}, description="Calculates the per-second average rate of increase of a [counter](docs-content://manage-data/data-store/data-streams/time-series-data-stream-tsds.md#time-series-metric). Rate calculations account for breaks in monotonicity, such as counter resets when a service restarts, and extrapolate values within each bucketed time interval. Rate is the most appropriate aggregate function for counters. It is only allowed in a [STATS](/reference/query-languages/esql/commands/stats-by.md) command under a [`TS`](/reference/query-languages/esql/commands/ts.md) source command, to be properly applied per time series.", appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.2.0")}, preview=true, examples={@Example(file="k8s-timeseries", tag="rate")})
    public Rate(Source source, @Param(name="field", type={"counter_long", "counter_integer", "counter_double"}, description="the counter field whose per-second average rate of increase is computed") Expression field, @Param(name="window", type={"time_duration"}, description="the time window over which the rate is computed", optional=true) Expression window, Expression timestamp) {
        this(source, field, (Expression)Literal.TRUE, (Expression)Objects.requireNonNullElse(window, NO_WINDOW), timestamp);
    }

    public Rate(Source source, Expression field, Expression filter, Expression window, Expression timestamp) {
        super(source, field, filter, window, List.of(timestamp));
        this.timestamp = timestamp;
    }

    public Rate(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), Rate.readWindow(in), (Expression)in.readNamedWriteableCollectionAsList(Expression.class).getFirst());
    }

    public String getWriteableName() {
        return Rate.ENTRY.name;
    }

    @Override
    protected NodeInfo<Rate> info() {
        return NodeInfo.create(this, Rate::new, this.field(), this.filter(), this.window(), this.timestamp);
    }

    @Override
    public Rate replaceChildren(List<Expression> newChildren) {
        return new Rate(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), newChildren.get(3));
    }

    @Override
    public Rate withFilter(Expression filter) {
        return new Rate(this.source(), this.field(), filter, this.window(), this.timestamp);
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType(this.field(), dt -> DataType.isCounter(dt), this.sourceText(), TypeResolutions.ParamOrdinal.FIRST, "counter_long", "counter_integer", "counter_double");
    }

    @Override
    public AggregatorFunctionSupplier supplier() {
        DataType type = this.field().dataType();
        DataType tsType = this.timestamp().dataType();
        boolean isDateNanos = tsType == DataType.DATE_NANOS;
        return switch (type) {
            case DataType.COUNTER_LONG -> new RateLongGroupingAggregatorFunction.FunctionSupplier(true, isDateNanos);
            case DataType.COUNTER_INTEGER -> new RateIntGroupingAggregatorFunction.FunctionSupplier(true, isDateNanos);
            case DataType.COUNTER_DOUBLE -> new RateDoubleGroupingAggregatorFunction.FunctionSupplier(true, isDateNanos);
            default -> throw EsqlIllegalArgumentException.illegalDataType(type);
        };
    }

    @Override
    public Rate perTimeSeriesAggregation() {
        return this;
    }

    @Override
    public String toString() {
        return "rate(" + String.valueOf(this.field()) + ", " + String.valueOf(this.timestamp()) + ")";
    }

    @Override
    public Expression timestamp() {
        return this.timestamp;
    }

    @Override
    public boolean requiredTimeSeriesSource() {
        return true;
    }
}

