/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.util.List;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Percentile;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;

public class PercentileOverTime
extends TimeSeriesAggregateFunction {
    @FunctionInfo(returnType={"double"}, description="Calculates the percentile over time of a field.", type=FunctionType.TIME_SERIES_AGGREGATE, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.3.0")}, preview=true, examples={@Example(file="k8s-timeseries", tag="percentile_over_time")})
    public PercentileOverTime(Source source, @Param(name="field", type={"double", "integer", "long", "exponential_histogram", "tdigest"}, description="the metric field to calculate the value for") Expression field, @Param(name="percentile", type={"double", "integer", "long"}, description="the percentile value to compute (between 0 and 100)") Expression percentile) {
        this(source, field, (Expression)Literal.TRUE, (Expression)NO_WINDOW, percentile);
    }

    public PercentileOverTime(Source source, Expression field, Expression filter, Expression window, Expression percentile) {
        super(source, field, filter, window, List.of(percentile));
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return this.perTimeSeriesAggregation().resolveType();
    }

    @Override
    public DataType dataType() {
        return this.perTimeSeriesAggregation().dataType();
    }

    @Override
    protected NodeInfo<PercentileOverTime> info() {
        return NodeInfo.create(this, PercentileOverTime::new, this.field(), this.filter(), this.window(), (Expression)this.children().get(3));
    }

    @Override
    public PercentileOverTime replaceChildren(List<Expression> newChildren) {
        return new PercentileOverTime(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), newChildren.get(3));
    }

    @Override
    public PercentileOverTime withFilter(Expression filter) {
        return new PercentileOverTime(this.source(), this.field(), filter, this.window(), (Expression)this.children().get(3));
    }

    @Override
    public AggregateFunction perTimeSeriesAggregation() {
        return new Percentile(this.source(), this.field(), this.filter(), this.window(), (Expression)this.children().get(3));
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("PercentileOverTime is not directly serializable");
    }
}

