/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MinBooleanAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MinBytesRefAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MinDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MinIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MinIpAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MinLongAggregatorFunctionSupplier;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlockBuilder;
import org.elasticsearch.compute.data.HistogramBlock;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.AggregateMetricDoubleNativeSupport;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.FromAggregateMetricDouble;
import org.elasticsearch.xpack.esql.expression.function.scalar.histogram.ExtractHistogramComponent;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMin;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Min
extends AggregateFunction
implements ToAggregator,
SurrogateExpression,
AggregateMetricDoubleNativeSupport {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Min", Min::new);
    private static final Map<DataType, Supplier<AggregatorFunctionSupplier>> SUPPLIERS = Map.ofEntries(Map.entry(DataType.BOOLEAN, MinBooleanAggregatorFunctionSupplier::new), Map.entry(DataType.LONG, MinLongAggregatorFunctionSupplier::new), Map.entry(DataType.UNSIGNED_LONG, MinLongAggregatorFunctionSupplier::new), Map.entry(DataType.DATETIME, MinLongAggregatorFunctionSupplier::new), Map.entry(DataType.DATE_NANOS, MinLongAggregatorFunctionSupplier::new), Map.entry(DataType.INTEGER, MinIntAggregatorFunctionSupplier::new), Map.entry(DataType.DOUBLE, MinDoubleAggregatorFunctionSupplier::new), Map.entry(DataType.IP, MinIpAggregatorFunctionSupplier::new), Map.entry(DataType.VERSION, MinBytesRefAggregatorFunctionSupplier::new), Map.entry(DataType.KEYWORD, MinBytesRefAggregatorFunctionSupplier::new), Map.entry(DataType.TEXT, MinBytesRefAggregatorFunctionSupplier::new));

    @FunctionInfo(returnType={"boolean", "double", "integer", "long", "date", "date_nanos", "ip", "keyword", "unsigned_long", "version"}, description="The minimum value of a field.", type=FunctionType.AGGREGATE, examples={@Example(file="stats", tag="min"), @Example(description="The expression can use inline functions. For example, to calculate the minimum over an average of a multivalued column, use `MV_AVG` to first average the multiple values per row, and use the result with the `MIN` function", file="stats", tag="docsStatsMinNestedExpression")})
    public Min(Source source, @Param(name="field", type={"aggregate_metric_double", "boolean", "double", "integer", "long", "date", "date_nanos", "ip", "keyword", "text", "unsigned_long", "version", "exponential_histogram", "tdigest"}) Expression field) {
        this(source, field, Literal.TRUE, NO_WINDOW);
    }

    public Min(Source source, Expression field, Expression filter, Expression window) {
        super(source, field, filter, window, Collections.emptyList());
    }

    private Min(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Min.ENTRY.name;
    }

    @Override
    protected NodeInfo<Min> info() {
        return NodeInfo.create(this, Min::new, this.field(), this.filter(), this.window());
    }

    @Override
    public Min replaceChildren(List<Expression> newChildren) {
        return new Min(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    public Min withFilter(Expression filter) {
        return new Min(this.source(), this.field(), filter, this.window());
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType(this.field(), dt -> SUPPLIERS.containsKey(dt) || dt == DataType.AGGREGATE_METRIC_DOUBLE || dt == DataType.EXPONENTIAL_HISTOGRAM || dt == DataType.TDIGEST, this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT, "boolean", "date", "ip", "string", "version", "aggregate_metric_double", "exponential_histogram", "tdigest", "numeric except counter types");
    }

    @Override
    public DataType dataType() {
        if (this.field().dataType() == DataType.AGGREGATE_METRIC_DOUBLE || this.field().dataType() == DataType.EXPONENTIAL_HISTOGRAM || this.field().dataType() == DataType.TDIGEST) {
            return DataType.DOUBLE;
        }
        return this.field().dataType().noText();
    }

    @Override
    public final AggregatorFunctionSupplier supplier() {
        DataType type = this.field().dataType();
        if (!SUPPLIERS.containsKey((Object)type)) {
            throw EsqlIllegalArgumentException.illegalDataType(type);
        }
        return SUPPLIERS.get((Object)type).get();
    }

    @Override
    public Expression surrogate() {
        if (this.field().dataType() == DataType.AGGREGATE_METRIC_DOUBLE) {
            return new Min(this.source(), FromAggregateMetricDouble.withMetric(this.source(), this.field(), AggregateMetricDoubleBlockBuilder.Metric.MIN), this.filter(), this.window());
        }
        if (this.field().dataType() == DataType.EXPONENTIAL_HISTOGRAM || this.field().dataType() == DataType.TDIGEST) {
            return new Min(this.source(), ExtractHistogramComponent.create(this.source(), this.field(), HistogramBlock.Component.MIN), this.filter(), this.window());
        }
        return this.field().foldable() ? new MvMin(this.source(), this.field()) : null;
    }
}

