/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.LastBytesRefByTimestampAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.LastDoubleByTimestampAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.LastFloatByTimestampAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.LastIntByTimestampAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.LastLongByTimestampAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Last
extends AggregateFunction
implements ToAggregator {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Last", Last::readFrom);
    private final Expression sort;

    @FunctionInfo(type=FunctionType.AGGREGATE, returnType={"long", "integer", "double", "keyword"}, description="Calculates the latest value of a field.", appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.GA, version="9.3.0")}, examples={@Example(file="stats_last", tag="last")})
    public Last(Source source, @Param(name="value", type={"long", "integer", "double", "keyword", "text"}, description="Values to return") Expression field, @Param(name="sort", type={"date", "date_nanos"}, description="Sort key") Expression sort) {
        this(source, field, (Expression)Literal.TRUE, (Expression)NO_WINDOW, sort);
    }

    private Last(Source source, Expression field, Expression filter, Expression window, Expression sort) {
        super(source, field, filter, window, List.of(sort));
        this.sort = sort;
    }

    private static Last readFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((PlanStreamInput)in);
        Expression field = (Expression)in.readNamedWriteable(Expression.class);
        Expression filter = (Expression)in.readNamedWriteable(Expression.class);
        Expression window = Last.readWindow(in);
        List params = in.readNamedWriteableCollectionAsList(Expression.class);
        Expression sort = (Expression)params.getFirst();
        return new Last(source, field, filter, window, sort);
    }

    public String getWriteableName() {
        return Last.ENTRY.name;
    }

    @Override
    protected NodeInfo<Last> info() {
        return NodeInfo.create(this, Last::new, this.field(), this.sort);
    }

    @Override
    public Last replaceChildren(List<Expression> newChildren) {
        return new Last(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), newChildren.get(3));
    }

    @Override
    public Last withFilter(Expression filter) {
        return new Last(this.source(), this.field(), filter, this.window(), this.sort);
    }

    public Expression sort() {
        return this.sort;
    }

    @Override
    public DataType dataType() {
        return this.field().dataType().noText();
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType(this.field(), dt -> dt == DataType.BOOLEAN || dt == DataType.DATETIME || DataType.isString(dt) || dt.isNumeric() && dt != DataType.UNSIGNED_LONG, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST, "boolean", "date", "ip", "string", "numeric except unsigned_long or counter types").and(TypeResolutions.isType(this.sort, dt -> dt == DataType.LONG || dt == DataType.DATETIME || dt == DataType.DATE_NANOS, this.sourceText(), TypeResolutions.ParamOrdinal.SECOND, "long or date_nanos or datetime"));
    }

    @Override
    public AggregatorFunctionSupplier supplier() {
        DataType type = this.field().dataType();
        return switch (type) {
            case DataType.LONG -> new LastLongByTimestampAggregatorFunctionSupplier();
            case DataType.INTEGER -> new LastIntByTimestampAggregatorFunctionSupplier();
            case DataType.DOUBLE -> new LastDoubleByTimestampAggregatorFunctionSupplier();
            case DataType.FLOAT -> new LastFloatByTimestampAggregatorFunctionSupplier();
            case DataType.KEYWORD, DataType.TEXT -> new LastBytesRefByTimestampAggregatorFunctionSupplier();
            default -> throw EsqlIllegalArgumentException.illegalDataType(type);
        };
    }

    @Override
    public String toString() {
        return "last(" + String.valueOf(this.field()) + ", " + String.valueOf(this.sort) + ")";
    }
}

