/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IrateDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IrateIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IrateLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.TimestampAware;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Irate
extends TimeSeriesAggregateFunction
implements OptionalArgument,
ToAggregator,
TimestampAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Irate", Irate::new);
    private final Expression timestamp;

    @FunctionInfo(type=FunctionType.TIME_SERIES_AGGREGATE, returnType={"double"}, description="Calculates the irate of a counter field. irate is the per-second rate of increase between the last two data points (it ignores all but the last two data points in each time period). This function is very similar to rate, but is more responsive to recent changes in the rate of increase.", appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.2.0")}, preview=true, examples={@Example(file="k8s-timeseries-irate", tag="irate")})
    public Irate(Source source, @Param(name="field", type={"counter_long", "counter_integer", "counter_double"}, description="the metric field to calculate the value for") Expression field, @Param(name="window", type={"time_duration"}, description="the time window over which to compute the irate", optional=true) Expression window, Expression timestamp) {
        this(source, field, (Expression)Literal.TRUE, (Expression)Objects.requireNonNullElse(window, NO_WINDOW), timestamp);
    }

    public Irate(Source source, Expression field, Expression filter, Expression window, Expression timestamp) {
        super(source, field, filter, window, List.of(timestamp));
        this.timestamp = timestamp;
    }

    public Irate(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), Irate.readWindow(in), (Expression)in.readNamedWriteableCollectionAsList(Expression.class).getFirst());
    }

    public String getWriteableName() {
        return Irate.ENTRY.name;
    }

    @Override
    protected NodeInfo<Irate> info() {
        return NodeInfo.create(this, Irate::new, this.field(), this.filter(), this.window(), this.timestamp);
    }

    @Override
    public Irate replaceChildren(List<Expression> newChildren) {
        return new Irate(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), newChildren.get(3));
    }

    @Override
    public Irate withFilter(Expression filter) {
        return new Irate(this.source(), this.field(), filter, this.window(), this.timestamp);
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType(this.field(), dt -> DataType.isCounter(dt), this.sourceText(), TypeResolutions.ParamOrdinal.FIRST, "counter_long", "counter_integer", "counter_double");
    }

    @Override
    public AggregatorFunctionSupplier supplier() {
        DataType type = this.field().dataType();
        DataType tsType = this.timestamp().dataType();
        boolean isDateNanos = tsType == DataType.DATE_NANOS;
        return switch (type) {
            case DataType.COUNTER_LONG -> new IrateLongAggregatorFunctionSupplier(false, isDateNanos);
            case DataType.COUNTER_INTEGER -> new IrateIntAggregatorFunctionSupplier(false, isDateNanos);
            case DataType.COUNTER_DOUBLE -> new IrateDoubleAggregatorFunctionSupplier(false, isDateNanos);
            default -> throw EsqlIllegalArgumentException.illegalDataType(type);
        };
    }

    @Override
    public Irate perTimeSeriesAggregation() {
        return this;
    }

    @Override
    public String toString() {
        return "irate(" + String.valueOf(this.field()) + ", " + String.valueOf(this.timestamp()) + ")";
    }

    @Override
    public Expression timestamp() {
        return this.timestamp;
    }
}

