/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.capabilities.Unresolvable;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.type.UnsupportedEsField;
import org.elasticsearch.xpack.esql.core.util.PlanStreamOutput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public final class UnsupportedAttribute
extends FieldAttribute
implements Unresolvable {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Attribute.class, "UnsupportedAttribute", UnsupportedAttribute::readFrom);
    public static final NamedWriteableRegistry.Entry NAMED_EXPRESSION_ENTRY = new NamedWriteableRegistry.Entry(NamedExpression.class, UnsupportedAttribute.ENTRY.name, UnsupportedAttribute::readFrom);
    public static final NamedWriteableRegistry.Entry EXPRESSION_ENTRY = new NamedWriteableRegistry.Entry(Expression.class, UnsupportedAttribute.ENTRY.name, UnsupportedAttribute::readFrom);
    private final boolean hasCustomMessage;
    private final String message;

    private static String errorMessage(String name, UnsupportedEsField field) {
        return "Cannot use field [" + name + "] with unsupported type [" + String.join((CharSequence)",", field.getOriginalTypes()) + "]";
    }

    public UnsupportedAttribute(Source source, String name, UnsupportedEsField field) {
        this(source, name, field, null);
    }

    public UnsupportedAttribute(Source source, String name, UnsupportedEsField field, @Nullable String customMessage) {
        this(source, name, field, customMessage, null);
    }

    public UnsupportedAttribute(Source source, String name, UnsupportedEsField field, @Nullable String customMessage, @Nullable NameId id) {
        this(source, null, name, field, customMessage, id);
    }

    public UnsupportedAttribute(Source source, @Nullable String qualifier, String name, UnsupportedEsField field, @Nullable String customMessage, @Nullable NameId id) {
        super(source, null, qualifier, name, field, Nullability.TRUE, id, false);
        this.hasCustomMessage = customMessage != null;
        this.message = customMessage == null ? UnsupportedAttribute.errorMessage(this.name(), field) : customMessage;
    }

    private static UnsupportedAttribute innerReadFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((PlanStreamInput)in);
        String qualifier = UnsupportedAttribute.readQualifier((PlanStreamInput)in, in.getTransportVersion());
        String name = ((PlanStreamInput)in).readCachedString();
        UnsupportedEsField field = (UnsupportedEsField)EsField.readFrom(in);
        String message = in.readOptionalString();
        NameId id = NameId.readFrom((PlanStreamInput)in);
        return new UnsupportedAttribute(source, qualifier, name, field, message, id);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (((PlanStreamOutput)out).writeAttributeCacheHeader(this)) {
            Source.EMPTY.writeTo(out);
            this.checkAndSerializeQualifier((PlanStreamOutput)out, out.getTransportVersion());
            ((PlanStreamOutput)out).writeCachedString(this.name());
            this.field().writeTo(out);
            out.writeOptionalString(this.hasCustomMessage ? this.message : null);
            this.id().writeTo(out);
        }
    }

    public static UnsupportedAttribute readFrom(StreamInput in) throws IOException {
        return (UnsupportedAttribute)((PlanStreamInput)in).readAttributeWithCache(UnsupportedAttribute::innerReadFrom);
    }

    @Override
    public String getWriteableName() {
        return UnsupportedAttribute.ENTRY.name;
    }

    @Override
    public boolean resolved() {
        return false;
    }

    @Override
    public UnsupportedEsField field() {
        return (UnsupportedEsField)super.field();
    }

    @Override
    public FieldAttribute.FieldName fieldName() {
        if (this.lazyFieldName == null) {
            this.lazyFieldName = new FieldAttribute.FieldName(this.name());
        }
        return this.lazyFieldName;
    }

    @Override
    protected NodeInfo<FieldAttribute> info() {
        return NodeInfo.create(this, UnsupportedAttribute::new, this.qualifier(), this.name(), this.field(), this.hasCustomMessage ? this.message : null, this.id());
    }

    @Override
    protected Attribute clone(Source source, String qualifier, String name, DataType type, Nullability nullability, NameId id, boolean synthetic) {
        return new UnsupportedAttribute(source, qualifier, name, this.field(), this.hasCustomMessage ? this.message : null, id);
    }

    @Override
    protected String label() {
        return "!";
    }

    @Override
    public String toString() {
        return "!" + this.qualifiedName();
    }

    @Override
    public String nodeString() {
        return this.toString();
    }

    @Override
    public String unresolvedMessage() {
        return this.message;
    }

    public boolean hasCustomMessage() {
        return this.hasCustomMessage;
    }

    @Override
    protected int innerHashCode(boolean ignoreIds) {
        return Objects.hash(super.innerHashCode(ignoreIds), this.hasCustomMessage, this.message);
    }

    @Override
    protected boolean innerEquals(Object o, boolean ignoreIds) {
        UnsupportedAttribute other = (UnsupportedAttribute)o;
        return super.innerEquals(other, ignoreIds) && this.hasCustomMessage == other.hasCustomMessage && Objects.equals(this.message, other.message);
    }

    public List<String> originalTypes() {
        return this.field().getOriginalTypes();
    }
}

