/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.function.IntFunction;
import org.apache.lucene.search.Query;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.compute.operator.lookup.QueryList;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.plugin.EsqlFlags;
import org.elasticsearch.xpack.esql.stats.SearchContextStats;

public class BinaryComparisonQueryList
extends QueryList {
    private final EsqlBinaryComparison binaryComparison;
    private final IntFunction<Object> blockValueReader;
    private final SearchExecutionContext searchExecutionContext;
    private final LucenePushdownPredicates lucenePushdownPredicates;

    public BinaryComparisonQueryList(MappedFieldType field, SearchExecutionContext searchExecutionContext, Block leftHandSideBlock, EsqlBinaryComparison binaryComparison, ClusterService clusterService, AliasFilter aliasFilter, Warnings warnings) {
        super(field, searchExecutionContext, aliasFilter, leftHandSideBlock, new QueryList.OnlySingleValueParams(warnings, "LOOKUP JOIN encountered multi-value"));
        this.binaryComparison = (EsqlBinaryComparison)binaryComparison.swapLeftAndRight();
        this.blockValueReader = QueryList.createBlockValueReader((Block)leftHandSideBlock);
        this.searchExecutionContext = searchExecutionContext;
        this.lucenePushdownPredicates = LucenePushdownPredicates.from(SearchContextStats.from(List.of(searchExecutionContext)), new EsqlFlags(clusterService.getClusterSettings()));
    }

    public QueryList onlySingleValues(Warnings warnings, String multiValueWarningMessage) {
        throw new UnsupportedOperationException();
    }

    public Query doGetQuery(int position, int firstValueIndex, int valueCount) {
        Object value = this.blockValueReader.apply(firstValueIndex);
        EsqlBinaryComparison comparison = this.binaryComparison.getFunctionType().buildNewInstance(this.binaryComparison.source(), this.binaryComparison.left(), new Literal(this.binaryComparison.right().source(), value, this.binaryComparison.right().dataType()));
        try {
            if (TranslationAware.Translatable.YES == comparison.translatable(this.lucenePushdownPredicates)) {
                return comparison.asQuery(this.lucenePushdownPredicates, TranslatorHandler.TRANSLATOR_HANDLER).toQueryBuilder().toQuery(this.searchExecutionContext);
            }
            throw new IllegalStateException("Cannot translate join condition: " + String.valueOf(this.binaryComparison));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error while building query for join on filter:", e);
        }
    }
}

