/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedBiFunction;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LocalCircuitBreaker;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.OrdinalBytesRefBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.IndexedByShardId;
import org.elasticsearch.compute.lucene.IndexedByShardIdFromSingleton;
import org.elasticsearch.compute.lucene.read.ValuesSourceReaderOperator;
import org.elasticsearch.compute.operator.Driver;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.OutputOperator;
import org.elasticsearch.compute.operator.ProjectOperator;
import org.elasticsearch.compute.operator.SinkOperator;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.compute.operator.lookup.EnrichQuerySourceOperator;
import org.elasticsearch.compute.operator.lookup.LookupEnrichQueryGenerator;
import org.elasticsearch.compute.operator.lookup.MergePositionsOperator;
import org.elasticsearch.compute.operator.lookup.QueryList;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.planner.EsPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.plugin.EsqlPlugin;

public abstract class AbstractLookupService<R extends Request, T extends TransportRequest> {
    private final String actionName;
    protected final ClusterService clusterService;
    protected final IndicesService indicesService;
    private final LookupShardContextFactory lookupShardContextFactory;
    protected final TransportService transportService;
    IndexNameExpressionResolver indexNameExpressionResolver;
    protected final Executor executor;
    private final BigArrays bigArrays;
    private final BlockFactory blockFactory;
    private final LocalCircuitBreaker.SizeSettings localBreakerSettings;
    private final ProjectResolver projectResolver;
    private final boolean mergePages;

    AbstractLookupService(String actionName, ClusterService clusterService, IndicesService indicesService, LookupShardContextFactory lookupShardContextFactory, TransportService transportService, IndexNameExpressionResolver indexNameExpressionResolver, BigArrays bigArrays, BlockFactory blockFactory, boolean mergePages, CheckedBiFunction<StreamInput, BlockFactory, T, IOException> readRequest, ProjectResolver projectResolver) {
        this.actionName = actionName;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.lookupShardContextFactory = lookupShardContextFactory;
        this.transportService = transportService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.executor = transportService.getThreadPool().executor("search");
        this.bigArrays = bigArrays;
        this.blockFactory = blockFactory;
        this.localBreakerSettings = new LocalCircuitBreaker.SizeSettings(clusterService.getSettings());
        this.mergePages = mergePages;
        this.projectResolver = projectResolver;
        transportService.registerRequestHandler(actionName, (Executor)transportService.getThreadPool().executor("esql_worker"), in -> (TransportRequest)((Object)((Object)readRequest.apply((Object)in, (Object)blockFactory))), (TransportRequestHandler)new TransportHandler());
    }

    public ThreadContext getThreadContext() {
        return this.transportService.getThreadPool().getThreadContext();
    }

    protected abstract T transportRequest(R var1, ShardId var2);

    protected abstract LookupEnrichQueryGenerator queryList(T var1, SearchExecutionContext var2, AliasFilter var3, Block var4, Warnings var5);

    protected abstract LookupResponse createLookupResponse(List<Page> var1, BlockFactory var2) throws IOException;

    protected abstract LookupResponse readLookupResponse(StreamInput var1, BlockFactory var2) throws IOException;

    protected static QueryList termQueryList(MappedFieldType field, SearchExecutionContext searchExecutionContext, AliasFilter aliasFilter, Block block, @Nullable DataType inputDataType) {
        DataType dataType = inputDataType;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"IP", "DATETIME", "DATE_NANOS"}, (DataType)dataType, n)) {
            case 0 -> QueryList.ipTermQueryList((MappedFieldType)field, (SearchExecutionContext)searchExecutionContext, (AliasFilter)aliasFilter, (BytesRefBlock)((BytesRefBlock)block));
            case 1 -> QueryList.dateTermQueryList((MappedFieldType)field, (SearchExecutionContext)searchExecutionContext, (AliasFilter)aliasFilter, (LongBlock)((LongBlock)block));
            case 2 -> QueryList.dateNanosTermQueryList((MappedFieldType)field, (SearchExecutionContext)searchExecutionContext, (AliasFilter)aliasFilter, (LongBlock)((LongBlock)block));
            default -> QueryList.rawTermQueryList((MappedFieldType)field, (SearchExecutionContext)searchExecutionContext, (AliasFilter)aliasFilter, (Block)block);
        };
    }

    public final void lookupAsync(R request, CancellableTask parentTask, ActionListener<List<Page>> outListener) {
        ClusterState clusterState = this.clusterService.state();
        ProjectState projectState = this.projectResolver.getProjectState(clusterState);
        List shardIterators = this.clusterService.operationRouting().searchShards(projectState, new String[]{((Request)request).index}, Map.of(), "_local");
        if (shardIterators.size() != 1) {
            outListener.onFailure((Exception)((Object)new EsqlIllegalArgumentException("target index {} has more than one shard", ((Request)request).index)));
            return;
        }
        ShardIterator shardIt = (ShardIterator)shardIterators.get(0);
        ShardRouting shardRouting = (ShardRouting)shardIt.nextOrNull();
        ShardId shardId = shardIt.shardId();
        if (shardRouting == null) {
            outListener.onFailure((Exception)new UnavailableShardsException(shardId, "target index is not available", new Object[0]));
            return;
        }
        DiscoveryNode targetNode = clusterState.nodes().get(shardRouting.currentNodeId());
        T transportRequest = this.transportRequest(request, shardId);
        this.sendChildRequest(parentTask, outListener, targetNode, transportRequest);
    }

    protected void sendChildRequest(CancellableTask parentTask, ActionListener<List<Page>> delegate, DiscoveryNode targetNode, T transportRequest) {
        this.transportService.sendChildRequest(targetNode, this.actionName, transportRequest, (Task)parentTask, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(delegate.map(LookupResponse::takePages), in -> this.readLookupResponse(in, this.blockFactory), this.executor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLookup(final T request, CancellableTask task, final ActionListener<List<Page>> listener) {
        for (int j = 0; j < ((TransportRequest)((Object)request)).inputPage.getBlockCount(); ++j) {
            Block inputBlock = ((TransportRequest)((Object)request)).inputPage.getBlock(j);
            if (!inputBlock.areAllValuesNull()) continue;
            List nullResponse = this.mergePages ? List.of(this.createNullResponse(((TransportRequest)((Object)request)).inputPage.getPositionCount(), ((TransportRequest)((Object)request)).extractFields)) : List.of();
            listener.onResponse(nullResponse);
            return;
        }
        ArrayList<Object> releasables = new ArrayList<Object>(6);
        boolean started = false;
        try {
            Operator finishPages;
            BytesRefBlock bytesRefBlock;
            OrdinalBytesRefBlock ordinalsBytesRefBlock;
            ProjectState projectState = this.projectResolver.getProjectState(this.clusterService.state());
            AliasFilter aliasFilter = this.indicesService.buildAliasFilter(projectState, ((TransportRequest)((Object)request)).shardId.getIndex().getName(), this.indexNameExpressionResolver.resolveExpressions(projectState.metadata(), new String[]{((TransportRequest)((Object)request)).indexPattern}));
            LookupShardContext shardContext = this.lookupShardContextFactory.create(((TransportRequest)((Object)request)).shardId);
            releasables.add(shardContext.release);
            LocalCircuitBreaker localBreaker = new LocalCircuitBreaker(this.blockFactory.breaker(), this.localBreakerSettings.overReservedBytes(), this.localBreakerSettings.maxOverReservedBytes());
            releasables.add(localBreaker);
            DriverContext driverContext = new DriverContext(this.bigArrays, this.blockFactory.newChildFactory(localBreaker));
            ElementType[] mergingTypes = new ElementType[((TransportRequest)((Object)request)).extractFields.size()];
            for (int i2 = 0; i2 < ((TransportRequest)((Object)request)).extractFields.size(); ++i2) {
                mergingTypes[i2] = PlannerUtils.toElementType(((TransportRequest)((Object)request)).extractFields.get(i2).dataType());
            }
            int[] mergingChannels = IntStream.range(0, ((TransportRequest)((Object)request)).extractFields.size()).map(i -> i + 2).toArray();
            Block inputBlock = ((TransportRequest)((Object)request)).inputPage.getBlock(0);
            if (this.mergePages && inputBlock instanceof BytesRefBlock && (ordinalsBytesRefBlock = (bytesRefBlock = (BytesRefBlock)inputBlock).asOrdinals()) != null) {
                inputBlock = ordinalsBytesRefBlock.getDictionaryVector().asBlock();
                selectedPositions = ordinalsBytesRefBlock.getOrdinalsBlock();
                finishPages = new MergePositionsOperator(1, mergingChannels, mergingTypes, selectedPositions, driverContext.blockFactory());
            } else if (this.mergePages) {
                selectedPositions = IntVector.range((int)0, (int)inputBlock.getPositionCount(), (BlockFactory)this.blockFactory).asBlock();
                try {
                    finishPages = new MergePositionsOperator(1, mergingChannels, mergingTypes, selectedPositions, driverContext.blockFactory());
                }
                finally {
                    if (selectedPositions != null) {
                        selectedPositions.close();
                    }
                }
            } else {
                finishPages = this.dropDocBlockOperator(((TransportRequest)((Object)request)).extractFields);
            }
            releasables.add(finishPages);
            Warnings warnings = Warnings.createWarnings((DriverContext.WarningsMode)DriverContext.WarningsMode.COLLECT, (int)((TransportRequest)((Object)request)).source.source().getLineNumber(), (int)((TransportRequest)((Object)request)).source.source().getColumnNumber(), (String)((TransportRequest)((Object)request)).source.text());
            LookupEnrichQueryGenerator queryList = this.queryList(request, shardContext.executionContext, aliasFilter, inputBlock, warnings);
            EnrichQuerySourceOperator queryOperator = new EnrichQuerySourceOperator(driverContext.blockFactory(), 256, queryList, (IndexedByShardId)new IndexedByShardIdFromSingleton((Object)shardContext.context), 0, warnings);
            releasables.add(queryOperator);
            ArrayList<Operator> operators = new ArrayList<Operator>();
            if (!((TransportRequest)((Object)request)).extractFields.isEmpty()) {
                Operator extractFieldsOperator = AbstractLookupService.extractFieldsOperator(shardContext.context, driverContext, ((TransportRequest)((Object)request)).extractFields);
                releasables.add(extractFieldsOperator);
                operators.add(extractFieldsOperator);
            }
            operators.add(finishPages);
            final List collectedPages = Collections.synchronizedList(new ArrayList());
            OutputOperator outputOperator = new OutputOperator(List.of(), Function.identity(), collectedPages::add);
            releasables.add(outputOperator);
            Driver driver = new Driver("enrich-lookup:" + ((TransportRequest)((Object)request)).sessionId, "enrich", this.clusterService.getClusterName().value(), this.clusterService.getNodeName(), System.currentTimeMillis(), System.nanoTime(), driverContext, () -> request.toString(), (SourceOperator)queryOperator, operators, (SinkOperator)outputOperator, Driver.DEFAULT_STATUS_INTERVAL, Releasables.wrap((Releasable[])new Releasable[]{shardContext.release, localBreaker}));
            task.addListener(() -> {
                String reason = Objects.requireNonNullElse(task.getReasonCancelled(), "task was cancelled");
                driver.cancel(reason);
            });
            ThreadContext threadContext = this.transportService.getThreadPool().getThreadContext();
            Driver.start((ThreadContext)threadContext, (Executor)this.executor, (Driver)driver, (int)10000, (ActionListener)new ActionListener<Void>(){

                public void onResponse(Void unused) {
                    List<Page> out = collectedPages;
                    if (AbstractLookupService.this.mergePages && out.isEmpty()) {
                        out = List.of(AbstractLookupService.this.createNullResponse(request.inputPage.getPositionCount(), request.extractFields));
                    }
                    listener.onResponse((Object)out);
                }

                public void onFailure(Exception e) {
                    Releasables.closeExpectNoException((Releasable)Releasables.wrap(() -> Iterators.map(collectedPages.iterator(), p -> () -> {
                        p.allowPassingToDifferentDriver();
                        p.releaseBlocks();
                    })));
                    listener.onFailure(e);
                }
            });
            started = true;
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
        finally {
            if (!started) {
                Releasables.close(releasables);
            }
        }
    }

    private static Operator extractFieldsOperator(EsPhysicalOperationProviders.ShardContext shardContext, DriverContext driverContext, List<NamedExpression> extractFields) {
        ArrayList<ValuesSourceReaderOperator.FieldInfo> fields = new ArrayList<ValuesSourceReaderOperator.FieldInfo>(extractFields.size());
        for (NamedExpression extractField : extractFields) {
            String string;
            if (extractField instanceof FieldAttribute) {
                FieldAttribute fa = (FieldAttribute)extractField;
                string = fa.fieldName().string();
            } else if (extractField instanceof Alias) {
                Alias a = (Alias)extractField;
                string = ((NamedExpression)a.child()).name();
            } else {
                string = extractField.name();
            }
            String fieldName = string;
            BlockLoader loader = shardContext.blockLoader(fieldName, extractField.dataType() == DataType.UNSUPPORTED, MappedFieldType.FieldExtractPreference.NONE, null);
            fields.add(new ValuesSourceReaderOperator.FieldInfo(extractField.name(), PlannerUtils.toElementType(extractField.dataType()), false, shardIdx -> {
                if (shardIdx != 0) {
                    throw new IllegalStateException("only one shard");
                }
                return loader;
            }));
        }
        return new ValuesSourceReaderOperator(driverContext.blockFactory(), Long.MAX_VALUE, fields, (IndexedByShardId)new IndexedByShardIdFromSingleton((Object)new ValuesSourceReaderOperator.ShardContext(shardContext.searcher().getIndexReader(), arg_0 -> ((EsPhysicalOperationProviders.ShardContext)shardContext).newSourceLoader(arg_0), ((Double)EsqlPlugin.STORED_FIELDS_SEQUENTIAL_PROPORTION.getDefault(Settings.EMPTY)).doubleValue())), 0);
    }

    private Operator dropDocBlockOperator(List<NamedExpression> extractFields) {
        int end = extractFields.size() + 1;
        ArrayList<Integer> projection = new ArrayList<Integer>(end);
        for (int i = 1; i <= end; ++i) {
            projection.add(i);
        }
        return new ProjectOperator(projection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page createNullResponse(int positionCount, List<NamedExpression> extractFields) {
        Block[] blocks = new Block[extractFields.size()];
        try {
            for (int i = 0; i < extractFields.size(); ++i) {
                blocks[i] = this.blockFactory.newConstantNullBlock(positionCount);
            }
            Page page = new Page(blocks);
            return page;
        }
        finally {
            if (blocks[blocks.length - 1] == null) {
                Releasables.close((Releasable[])blocks);
            }
        }
    }

    public static interface LookupShardContextFactory {
        public LookupShardContext create(ShardId var1) throws IOException;

        public static LookupShardContextFactory fromSearchService(SearchService searchService) {
            return shardId -> {
                ShardSearchRequest shardSearchRequest = new ShardSearchRequest(shardId, 0L, AliasFilter.EMPTY);
                return LookupShardContext.fromSearchContext(searchService.createSearchContext(shardSearchRequest, SearchService.NO_TIMEOUT));
            };
        }
    }

    private class TransportHandler
    implements TransportRequestHandler<T> {
        private TransportHandler() {
        }

        public void messageReceived(T request, TransportChannel channel, Task task) {
            ((TransportRequest)((Object)request)).incRef();
            ActionListener listener = ActionListener.runBefore((ActionListener)new ChannelActionListener(channel), () -> request.decRef());
            AbstractLookupService.this.doLookup(request, (CancellableTask)task, (ActionListener<List<Page>>)listener.delegateFailureAndWrap((l, resultPages) -> ActionListener.respondAndRelease((ActionListener)l, (RefCounted)AbstractLookupService.this.createLookupResponse((List<Page>)resultPages, AbstractLookupService.this.blockFactory))));
        }
    }

    static abstract class Request {
        final String sessionId;
        final String index;
        final String indexPattern;
        final DataType inputDataType;
        final Page inputPage;
        final List<NamedExpression> extractFields;
        final Source source;

        Request(String sessionId, String index, String indexPattern, DataType inputDataType, Page inputPage, List<NamedExpression> extractFields, Source source) {
            this.sessionId = sessionId;
            this.index = index;
            this.indexPattern = indexPattern;
            this.inputDataType = inputDataType;
            this.inputPage = inputPage;
            this.extractFields = extractFields;
            this.source = source;
        }
    }

    static abstract class TransportRequest
    extends AbstractTransportRequest
    implements IndicesRequest {
        final String sessionId;
        final ShardId shardId;
        final String indexPattern;
        final Page inputPage;
        final List<NamedExpression> extractFields;
        final Source source;
        final Page toRelease;
        final RefCounted refs = AbstractRefCounted.of(this::releasePage);

        TransportRequest(String sessionId, ShardId shardId, String indexPattern, Page inputPage, Page toRelease, List<NamedExpression> extractFields, Source source) {
            this.sessionId = sessionId;
            this.shardId = shardId;
            this.indexPattern = indexPattern;
            this.inputPage = inputPage;
            this.toRelease = toRelease;
            this.extractFields = extractFields;
            this.source = source;
        }

        public Page getInputPage() {
            return this.inputPage;
        }

        public final String[] indices() {
            return new String[]{this.indexPattern};
        }

        public final IndicesOptions indicesOptions() {
            return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }

        public final Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(this, id, type, action, "", parentTaskId, headers){

                public String getDescription() {
                    return this.toString();
                }
            };
        }

        private void releasePage() {
            if (this.toRelease != null) {
                Releasables.closeExpectNoException(() -> ((Page)this.toRelease).releaseBlocks());
            }
        }

        public final void incRef() {
            this.refs.incRef();
        }

        public final boolean tryIncRef() {
            return this.refs.tryIncRef();
        }

        public final boolean decRef() {
            return this.refs.decRef();
        }

        public final boolean hasReferences() {
            return this.refs.hasReferences();
        }

        public final String toString() {
            return "LOOKUP( session=" + this.sessionId + " ,shard=" + String.valueOf(this.shardId) + " ,extract_fields=" + String.valueOf(this.extractFields) + " ,positions=" + this.inputPage.getPositionCount() + this.extraDescription() + ")";
        }

        protected abstract String extraDescription();
    }

    public record LookupShardContext(EsPhysicalOperationProviders.ShardContext context, SearchExecutionContext executionContext, Releasable release) {
        public static LookupShardContext fromSearchContext(SearchContext searchContext) {
            return new LookupShardContext(new EsPhysicalOperationProviders.DefaultShardContext(0, (Releasable)searchContext, searchContext.getSearchExecutionContext(), searchContext.request().getAliasFilter()), searchContext.getSearchExecutionContext(), (Releasable)searchContext);
        }
    }

    static abstract class LookupResponse
    extends TransportResponse {
        private final RefCounted refs = AbstractRefCounted.of(this::release);
        protected final BlockFactory blockFactory;
        protected long reservedBytes = 0L;

        LookupResponse(BlockFactory blockFactory) {
            this.blockFactory = blockFactory;
        }

        protected abstract List<Page> takePages();

        private void release() {
            this.blockFactory.breaker().addWithoutBreaking(-this.reservedBytes);
            this.innerRelease();
        }

        protected abstract void innerRelease();

        public void incRef() {
            this.refs.incRef();
        }

        public boolean tryIncRef() {
            return this.refs.tryIncRef();
        }

        public boolean decRef() {
            return this.refs.decRef();
        }

        public boolean hasReferences() {
            return this.refs.hasReferences();
        }
    }
}

