/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.esql.plan.IndexPattern;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnresolvedRelation;

public class PreAnalyzer {
    public PreAnalysis preAnalyze(LogicalPlan plan) {
        if (plan.analyzed()) {
            return PreAnalysis.EMPTY;
        }
        return this.doPreAnalyze(plan);
    }

    protected PreAnalysis doPreAnalyze(LogicalPlan plan) {
        HashMap<IndexPattern, IndexMode> indexes = new HashMap<IndexPattern, IndexMode>();
        ArrayList<IndexPattern> lookupIndices = new ArrayList<IndexPattern>();
        plan.forEachUp(UnresolvedRelation.class, p -> {
            if (p.indexMode() == IndexMode.LOOKUP) {
                lookupIndices.add(p.indexPattern());
            } else if (!indexes.containsKey(p.indexPattern()) || indexes.get(p.indexPattern()) == p.indexMode()) {
                indexes.put(p.indexPattern(), p.indexMode());
            } else {
                IndexMode m1 = p.indexMode();
                IndexMode m2 = (IndexMode)indexes.get(p.indexPattern());
                throw new IllegalStateException("index pattern '" + String.valueOf(p.indexPattern()) + "' found with with different index mode: " + String.valueOf(m2) + " != " + String.valueOf(m1));
            }
        });
        ArrayList<Enrich> unresolvedEnriches = new ArrayList<Enrich>();
        plan.forEachUp(Enrich.class, unresolvedEnriches::add);
        Holder useAggregateMetricDoubleWhenNotSupported = new Holder((Object)false);
        Holder useDenseVectorWhenNotSupported = new Holder((Object)false);
        indexes.forEach((ip, mode) -> {
            if (mode == IndexMode.TIME_SERIES) {
                useAggregateMetricDoubleWhenNotSupported.set((Object)true);
            }
        });
        plan.forEachDown(p -> p.forEachExpression(UnresolvedFunction.class, fn -> {
            if (fn.name().equalsIgnoreCase("knn") || fn.name().equalsIgnoreCase("to_dense_vector") || fn.name().equalsIgnoreCase("v_cosine") || fn.name().equalsIgnoreCase("v_hamming") || fn.name().equalsIgnoreCase("v_l1_norm") || fn.name().equalsIgnoreCase("v_l2_norm") || fn.name().equalsIgnoreCase("v_dot_product") || fn.name().equalsIgnoreCase("v_magnitude")) {
                useDenseVectorWhenNotSupported.set((Object)true);
            }
            if (fn.name().equalsIgnoreCase("to_aggregate_metric_double")) {
                useAggregateMetricDoubleWhenNotSupported.set((Object)true);
            }
        }));
        plan.forEachUp(LogicalPlan::setPreAnalyzed);
        return new PreAnalysis(indexes, unresolvedEnriches, lookupIndices, (Boolean)useAggregateMetricDoubleWhenNotSupported.get(), (Boolean)useDenseVectorWhenNotSupported.get());
    }

    public record PreAnalysis(Map<IndexPattern, IndexMode> indexes, List<Enrich> enriches, List<IndexPattern> lookupIndices, boolean useAggregateMetricDoubleWhenNotSupported, boolean useDenseVectorWhenNotSupported) {
        public static final PreAnalysis EMPTY = new PreAnalysis(Map.of(), List.of(), List.of(), false, false);
    }
}

