/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.test.rest.yaml.section.DoSection;
import org.elasticsearch.test.rest.yaml.section.ExecutableSection;
import org.elasticsearch.test.rest.yaml.section.ParserUtils;
import org.elasticsearch.test.rest.yaml.section.PrerequisiteSection;
import org.elasticsearch.test.rest.yaml.section.SetSection;
import org.elasticsearch.xcontent.XContentParser;

public class SetupSection {
    public static final SetupSection EMPTY = new SetupSection(PrerequisiteSection.EMPTY, Collections.emptyList());
    private final PrerequisiteSection prerequisiteSection;
    private final List<ExecutableSection> executableSections;

    static SetupSection parseIfNext(XContentParser parser) throws IOException {
        ParserUtils.advanceToFieldName(parser);
        if ("setup".equals(parser.currentName())) {
            parser.nextToken();
            SetupSection section = SetupSection.parse(parser);
            parser.nextToken();
            return section;
        }
        return EMPTY;
    }

    public static SetupSection parse(XContentParser parser) throws IOException {
        PrerequisiteSection prerequisiteSection = PrerequisiteSection.parseIfNext(parser);
        ArrayList<ExecutableSection> executableSections = new ArrayList<ExecutableSection>();
        while (parser.currentToken() != XContentParser.Token.END_ARRAY) {
            ParserUtils.advanceToFieldName(parser);
            if ("do".equals(parser.currentName())) {
                executableSections.add(DoSection.parse(parser));
            } else if ("set".equals(parser.currentName())) {
                executableSections.add(SetSection.parse(parser));
            } else {
                throw new IllegalArgumentException("section [" + parser.currentName() + "] not supported within setup section");
            }
            parser.nextToken();
        }
        parser.nextToken();
        return new SetupSection(prerequisiteSection, executableSections);
    }

    public SetupSection(PrerequisiteSection prerequisiteSection, List<ExecutableSection> executableSections) {
        this.prerequisiteSection = Objects.requireNonNull(prerequisiteSection, "skip section cannot be null");
        this.executableSections = Collections.unmodifiableList(executableSections);
    }

    public PrerequisiteSection getPrerequisiteSection() {
        return this.prerequisiteSection;
    }

    public List<ExecutableSection> getExecutableSections() {
        return this.executableSections;
    }

    public boolean isEmpty() {
        return EMPTY.equals(this);
    }
}

