/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.compute.operator.PlanTimeProfile;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record PlanProfile(String description, String clusterName, String nodeName, String planTree, PlanTimeProfile planTimeProfile) implements Writeable,
ToXContentObject
{
    private static final TransportVersion PLAN_PROFILE_VERSION = TransportVersion.fromName((String)"plan_profile_version");

    public static PlanProfile readFrom(StreamInput in) throws IOException {
        String description = in.readString();
        String clusterName = in.readString();
        String nodeName = in.readString();
        String planTree = in.readString();
        PlanTimeProfile profile = null;
        if (in.getTransportVersion().supports(PLAN_PROFILE_VERSION)) {
            profile = (PlanTimeProfile)in.readOptionalWriteable(PlanTimeProfile::new);
        }
        return new PlanProfile(description, clusterName, nodeName, planTree, profile);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.description);
        out.writeString(this.clusterName);
        out.writeString(this.nodeName);
        out.writeString(this.planTree);
        if (out.getTransportVersion().supports(PLAN_PROFILE_VERSION)) {
            out.writeOptionalWriteable((Writeable)this.planTimeProfile);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("description", this.description);
        builder.field("cluster_name", this.clusterName);
        builder.field("node_name", this.nodeName);
        builder.field("plan", this.planTree);
        if (this.planTimeProfile != null) {
            this.planTimeProfile.toXContent(builder, params);
        }
        return builder.endObject();
    }
}

