/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.transport.TransportException;

public final class FailureCollector {
    private final Map<Category, Queue<Exception>> categories;
    private final int maxExceptions;
    private volatile boolean hasFailure = false;
    private Exception finalFailure = null;

    public FailureCollector() {
        this(10);
    }

    public FailureCollector(int maxExceptions) {
        if (maxExceptions <= 0) {
            throw new IllegalArgumentException("maxExceptions must be at least one");
        }
        this.maxExceptions = maxExceptions;
        this.categories = new EnumMap<Category, Queue<Exception>>(Category.class);
        for (Category c : Category.values()) {
            this.categories.put(c, new ArrayBlockingQueue(maxExceptions));
        }
    }

    public static Exception unwrapTransportException(TransportException te) {
        Throwable cause = te.getCause();
        if (cause == null) {
            return te;
        }
        if (cause instanceof Exception) {
            Exception ex = (Exception)cause;
            return ex;
        }
        return new ElasticsearchException(cause);
    }

    private static Category getErrorCategory(Exception e) {
        if (ExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{TaskCancelledException.class}) != null) {
            return Category.CANCELLATION;
        }
        if (TransportActions.isShardNotAvailableException((Throwable)e)) {
            return Category.SHARD_UNAVAILABLE;
        }
        int status = ExceptionsHelper.status((Throwable)e).getStatus();
        if (400 <= status && status < 500) {
            return Category.CLIENT;
        }
        return Category.SERVER;
    }

    public void unwrapAndCollect(Exception e) {
        Exception exception;
        if (e instanceof TransportException) {
            TransportException te = (TransportException)e;
            exception = FailureCollector.unwrapTransportException(te);
        } else {
            exception = e;
        }
        e = exception;
        this.categories.get((Object)FailureCollector.getErrorCategory(e)).offer(e);
        this.hasFailure = true;
    }

    public boolean hasFailure() {
        return this.hasFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception getFailure() {
        if (!this.hasFailure) {
            return null;
        }
        FailureCollector failureCollector = this;
        synchronized (failureCollector) {
            if (this.finalFailure == null) {
                this.finalFailure = this.buildFailure();
            }
            return this.finalFailure;
        }
    }

    private Exception buildFailure() {
        assert (this.hasFailure);
        assert (Thread.holdsLock(this));
        Exception first = null;
        int collected = 0;
        for (Category category : List.of(Category.CLIENT, Category.SERVER, Category.SHARD_UNAVAILABLE, Category.CANCELLATION)) {
            if (first != null && category == Category.CANCELLATION) continue;
            for (Exception e : this.categories.get((Object)category)) {
                if (++collected > this.maxExceptions) continue;
                if (first == null) {
                    first = e;
                    continue;
                }
                if (first == e) continue;
                first.addSuppressed(e);
            }
        }
        assert (first != null);
        return first;
    }

    private static enum Category {
        CLIENT,
        SERVER,
        SHARD_UNAVAILABLE,
        CANCELLATION;

    }
}

